#include <stdio.h>

int minCostPath(int nums[], int n) {
    for (int i = 2; i < n; i++) {
        nums[i] += (nums[i - 1] < nums[i - 2]) ? nums[i - 1] : nums[i - 2];
    }
    return (nums[n - 1] < nums[n - 2]) ? nums[n - 1] : nums[n - 2];
}

int main() {
    int numElements, numPlayers;

    printf("Enter the number of array elements: ");
    scanf("%d", &numElements);

    int originalArr[numElements];
    printf("Enter %d array elements separated by spaces: ", numElements);
    for (int i = 0; i < numElements; i++) {
        scanf("%d", &originalArr[i]);
    }

    printf("Enter the number of players for removing elements: ");
    scanf("%d", &numPlayers);

    int removals[numPlayers][numElements];
    for (int i = 0; i < numPlayers; i++) {
        printf("Enter indices of elements player %d wants to remove separated by spaces: ", i + 1);
        for (int j = 0; j < numElements; j++) {
            scanf("%d", &removals[i][j]);
            removals[i][j]--;
        }
    }

    int arr[numElements];
    for (int i = 0; i < numElements; i++) {
        arr[i] = originalArr[i];
    }

    if (numElements < 2) {
        printf("The array has less than 2 elements, the score is 0.\n");
    } else {
        for (int i = 0; i < numPlayers; i++) {
            for (int j = 0; j < numElements; j++) {
                arr[removals[i][j]] = 0;
            }

            int arrAfterRemoval[numElements];
            int count = 0;
            for (int j = 0; j < numElements; j++) {
                if (arr[j] != 0) {
                    arrAfterRemoval[count++] = arr[j];
                }
            }

            if (count < 2) {
                printf("The array after %d removal(s) has less than 2 elements, the score is 0.\n", i + 1);
            } else {
                int result = minCostPath(arrAfterRemoval, count);
                printf("Minimum sum of numbers after %d removal(s): %d\n", i + 1, result);
                printf("Elements of the array after removal: ");
                for (int k = 0; k < count; k++) {
                    printf("%d ", arrAfterRemoval[k]);
                }
                printf("\n");
            }
        }
    }

    return 0;
}