#include <stdio.h>

int minCostPath(int nums[], int n) {
    for (int i = 2; i < n; ++i) {
        nums[i] += (nums[i - 1] < nums[i - 2]) ? nums[i - 1] : nums[i - 2];
    }

    return (nums[n - 1] < nums[n - 2]) ? nums[n - 1] : nums[n - 2];
}

int main() {
    int num_elements;
    scanf("%d", &num_elements);

    int original_arr[num_elements];
    for (int i = 0; i < num_elements; ++i) {
        scanf("%d", &original_arr[i]);
    }

    int num_players;
    scanf("%d", &num_players);

    int removals[num_players][num_elements];
    for (int i = 0; i < num_players; ++i) {
        for (int j = 0; j < num_elements; ++j) {
            scanf("%d", &removals[i][j]);
            removals[i][j] -= 1;
        }
    }

    int arr[num_elements];
    for (int i = 0; i < num_elements; ++i) {
        arr[i] = original_arr[i];
    }

    if (num_elements < 2) {
        printf("0\n");
    } else {
        for (int i = 0; i < num_players; ++i) {
            for (int j = 0; j < num_elements; ++j) {
                arr[removals[i][j]] = 0;
            }

            int arr_after_removal[num_elements];
            int k = 0;
            for (int j = 0; j < num_elements; ++j) {
                if (arr[j] != 0) {
                    arr_after_removal[k++] = arr[j];
                }
            }

            if (k < 2) {
                printf("0\n");
            } else {
                int result = minCostPath(arr_after_removal, k);
                printf("%d\n", result);
            }
        }
    }

    return 0;
}