#include <iostream>
#include <vector>
#include <algorithm>
#include <limits.h>
using namespace std;

vector<int> min_score_after_tricks(int N, vector<long long>& A, int Q, vector<pair<int, int>>& tricks) {
    auto min_score = [](const vector<int>& arr) {
        int n = arr.size();
        vector<int> dp(n + 2, INT_MAX);
        dp[0] = dp[1] = 0;

        for (int i = 2; i < n + 2; ++i) {
            dp[i] = min(dp[i - 1] + arr[i - 2], dp[i - 2] + arr[i - 2]);
        }

        return dp[n + 1];
    };

    vector<int> result;
    for (const auto& trick : tricks) {
        int L = trick.first, R = trick.second;
        vector<int> B(A.begin(), A.begin() + L - 1);
        B.insert(B.end(), A.begin() + R  , A.end());
        result.push_back(min_score(B));
        
        
    }

    return result;
}

int main() {
    int N, Q;
    scanf("%d", &N);

    vector<long long> A(N);
    for (int i = 0; i < N; ++i) {
        scanf("%lld", &A[i]);
    }
    A.push_back(0);
    scanf("%d", &Q);

    vector<pair<int, int>> tricks(Q);
    for (int i = 0; i < Q; ++i) {
        scanf("%d" "%d",&tricks[i].first, &tricks[i].second );
    }

    vector<int> output = min_score_after_tricks(N, A, Q, tricks);

    for (int score : output) {
        cout << score << endl;
    }

    return 0;
}