#include <iostream>
#include <vector>
#include <climits>

using namespace std;

// Funkcija koja pronalazi minimum od dva broja.
int min(int a, int b) {
    return (a < b) ? a : b;
}

// Funkcija koja racuna minimum broja skokova do kraja niza.
int minJumpsToEnd(const vector<int>& arr) {
    int n = arr.size();

    // Ako je niz prazan ili prvi element 0, nemoguce je stici do kraja.
    if (n == 0 || arr[0] == 0) {
        return -1;
    }

    // Inicijalizacija niza za cuvanje minimalnog broja skokova do svakog elementa.
    vector<int> jumps(n, INT_MAX);
    jumps[0] = 0; // Nema skokova za prvi element.

    // Iteracija kroz sve elemente niza.
    for (int i = 1; i < n; ++i) {
        for (int j = 0; j < i; ++j) {
            // Ako je moguce stici do i-tog elementa iz j-tog i broj skokova manji od trenutnog minimuma.
            if (j + arr[j] >= i) {
                jumps[i] = min(jumps[i], jumps[j] + 1);
            }
        }
    }

    // Ako nije moguce stici do poslednjeg elementa.
    if (jumps[n - 1] == INT_MAX) {
        return -1;
    }

    // Vracanje minimuma broja skokova do kraja niza.
    return jumps[n - 1];
}

int main() {
    // Primer korišcenja funkcije.
    vector<int> arr = {1, 3, 5, 8, 9, 2, 6, 7, 6, 8, 9};
    int result = minJumpsToEnd(arr);

    cout << "Minimum broj skokova do kraja niza: " << result << endl;

    return 0;
}