#include <bits/stdc++.h>
using namespace std;

#define loop(i, s, e) for(int i = s; i < e; i++)
#define ll long long
#define ull long long

void dsu_init(vector<ll> &dsu) {
    loop(i, 0, dsu.size()) {
        dsu[i] = i;
    }
}

ull dsu_find(vector<ll> &dsu, ull x) {
    if (dsu[x] == x) return x;
    return dsu[x] = dsu_find(dsu, dsu[x]);
}

void dsu_merge(vector<ll> &dsu, ull a, ull b) {
    ull roota = dsu_find(dsu, a);
    ull rootb = dsu_find(dsu, b);
    if (roota != rootb) dsu[roota] = rootb;
}

void dsu_print(const vector<ll> &dsu) {
    loop(i, 0, dsu.size()) {
        cout << dsu[i] << ' ';
    }
    cout << '\n';
}

int knapsack(int N, int K, const vector<int> &s, const vector<int> &k, vector<vector<int>> &memo) {
    if (N == 0) {
        if (K >= k[0]) return s[0];
        return 0;
    }

    if (memo[N][K] == 0) {
        int a = 0;
        if (K >= k[N]) {
            a = knapsack(N - 1, K - k[N], s, k, memo) + s[N];
        }
        int b = knapsack(N - 1, K, s, k, memo);
        memo[N][K] = max(a, b);
    }

    return memo[N][K];
}

pair<int, int> make_knapsack(int N, int K, int p[], int s[], int k[], vector<int> &s1, vector<int> &k1, int index = 0) {
    if (p[index + 1] == 0) {
        auto pa = make_pair(s[index + 1], k[index + 1]);
        s1[index] = pa.first;
        k1[index] = pa.second;
        return pa;
    }
    if (s1[index] != -1) return make_pair(s1[index], k1[index]);
    pair<int, int> pa = make_knapsack(N, K, p, s, k, s1, k1, p[index + 1] - 1);
    s1[index] = pa.first + s[index + 1];
    k1[index] = pa.second + k[index + 1];
}


int MaxSpartanstvo(int N, int K, int p[], int s[], int k[]) {

    vector<int> s1(N, -1);
    vector<int> k1(N);
    loop(i, 0, N) {
        make_knapsack(N, K, p, s, k, s1, k1, i);
    }
    vector<vector<int>> memo(N + 1, vector<int>(K + 1, 0));

    return knapsack(N - 1, K, s1, k1, memo);
};