#include <bits/stdc++.h>
using namespace std;

#define loop(i, s, e) for(int i = s; i < e; i++)
#define ll long long
#define ull unsigned long long


void dsu_init(vector<ll> &dsu) {
    loop(i, 0, dsu.size()) {
        dsu[i] = i;
    }
}

ull dsu_find(vector<ll> &dsu, ull x) {
    if (dsu[x] == x) return x;
    return dsu[x] = dsu_find(dsu, dsu[x]);
}

void dsu_merge(vector<ll> &dsu, ull a, ull b) {
    ull roota = dsu_find(dsu, a);
    ull rootb = dsu_find(dsu, b);
    if (roota != rootb) dsu[roota] = rootb;
}

void dsu_print(const vector<ll> &dsu) {
    loop(i, 0, dsu.size()) {
        cout << dsu[i] << ' ';
    }
    cout << '\n';
}

int knapsack(int N, int K, const vector<int> &s, const vector<int> &k, vector<vector<ull>> &memo) {
    if (N == 0) {
        if (K >= k[0]) return s[0];
        return 0;
    }

    if (memo[N][K] == 0) {
        int a = 0;
        if (K >= k[N]) {
            a = knapsack(N - 1, K - k[N], s, k, memo) + s[N];
        }
        int b = knapsack(N - 1, K, s, k, memo);
        memo[N][K] = max(a, b);
    }

    return memo[N][K];
}

pair<ll, ll> init_bd(int d, vector<int> &index, bool u[], int p[], int s[], int k[]) {
    int ksum = 0;
    int ssum = 0;
    int i = d;
    while(i > 0 && !u[i]) {
        index.push_back(i);
        u[i] = true;
        ksum += k[i];
        ssum += s[i];
        i = p[i];
    }
    return make_pair(ssum, ksum);
}

void delete_bd(const vector<int> &index, bool u[], int p[]) {
    loop(i, 0, index.size()) {
        u[index[i]] = false;
    }
}

int ms(int N, int d, int K, bool u[], int p[], int s[], int k[]) {
    int t = 0;

    if (d > N) return 0;
    if (K >= k[d] && !u[d]) {
        vector<int> index;
        pair<ll, ll> sk = init_bd(d, index, u, p, s, k);
        if (K >= sk.second) {
            t = ms(N, d + 1, K - sk.second, u, p, s, k) + sk.first;
        }
        delete_bd(index, u, p);
    }

    int n = ms(N, d + 1, K, u, p, s, k);
    return max(t, n);
}

int MaxSpartanstvo(int N, int K, int p[], int s[], int k[]) {
    bool is2 = true;
    bool is3 = true;
    loop(i, 1, N + 1) {
        if (p[i] == 0) is3 = false;
        if (p[i] != i - 1) is2 = false;
    }

    if (is3) {
        vector<ll> dsu(N);
        dsu_init(dsu);
        loop(i, 1, N + 1) {
            dsu_merge(dsu, i - 1, p[i] - 1);
        }

        unordered_map<ull, pair<ull, ull>> a;
        loop(i, 0, N) {
            ull root = dsu_find(dsu, i);
            a[root] = make_pair(0, 0);
            dsu[i] = root;
        }

        loop(i, 0, N) {
            a[dsu[i]].first += s[i + 1];
            a[dsu[i]].second += k[i + 1];
        }

        vector<int> s1;
        s1.reserve(a.size());
        vector<int> k1;
        k1.reserve(a.size());
        for(auto &x : a) {
            s1.push_back(x.second.first);
            k1.push_back(x.second.second);
        }

        vector<vector<ull>> memo(N, vector<ull>(K + 1, 0));

        return knapsack(a.size() - 1, K, s1, k1, memo);
    } else if (is2) {
        ll sum = 0;
        loop(i, 1, N + 1) {
            if (K >= k[i]) {
                sum += s[i];
                K -= k[i];
            } else {
                break;
            }
        }
        return sum;
    } else {
        bool *u = new bool[N+1];
        loop(i, 0, N + 1) {
            u[i] = false;
        }
        return ms(N, 1, K, u, p, s, k);
    }
};