#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef pair<int, int> pi;
typedef pair<ll, ll> pl;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<double> vd;
typedef vector<bool> vb;
typedef vector<char> vc;
typedef vector<string> vs;
typedef vector<pi> vp;
typedef vector<pl> vpl;
typedef vector<vi> vvi;

vvi calc(vvi& e, int n) {
	vi vis(n), deg(n);
	queue<int> q;

	for (int i = 0; i < n; i++) {
		deg[i] = e[i].size();
		
		if (deg[i] <= 5) 
			q.push(i);
	}
	
	vvi sol(n);

	while (!q.empty()) {
		ll c = q.front();
		q.pop();
		
		if (vis[c]) 
			continue;
		
		vis[c] = 1;
		
		for (int x : e[c]) {
			if (vis[x]) 
				continue;
			--deg[x];
			
			sol[c].push_back(x);
			
			if (deg[x] == 5) 
				q.push(x);
		}
	}
	return sol;
}


int Mesi(int n, int m, int* x, int* y, int* a, int* b){
	vvi e(n);
	for (int i = 1; i <= m; i++){
		e[a[i]-1].push_back(b[i]-1);
		e[b[i]-1].push_back(a[i]-1);
	}
	e = calc(e, n);

	int sol = 5;
	vi dist(n, -1);
	
	for (int i = 0; i < n; i++){
		queue<int> q;
		q.push(i);
		vi vis;
		dist[i] = 0;
		
		while (!q.empty()){
			int c = q.front();
			vis.push_back(c);
			
			q.pop();
			
			for (int x : e[c]) {
				if (dist[x] < 0) {
					if (dist[c] + 1 <= 3){ 
						dist[x] = dist[c] + 1;
						q.push(x);
					}
				} else {
					sol = min(sol, dist[x] + dist[c] + 1);
				}
			}
		}

		for (int x : vis) 
			dist[x] = -1;
	}


	if (sol == 5){
		set<pi> ob;
		
		for (int i = 0; i < n; i++) {
			for (int j = 0; j < e[i].size(); j++) {
				for (ll k = 0; k < j; k++) {
					int u = e[i][j];
					int v = e[i][k];
					
					if (u > v) 
						swap(u, v);


					if (ob.find(make_pair(u, v)) != ob.end()) 
						return 4;
					else 
						ob.insert({u, v});
				}
			}
		}
	}

	return sol;
}

int main() {
    ios::sync_with_stdio(false); cin.tie(0);

    int test;
    cin >> test;

    while(test--){
        int n, m; cin >> n >> m;

        int *x = new int[n+1];
        int *y = new int[n+1];
        int *a = new int[m+1];
        int *b = new int[m+1];

        for (int i = 1; i <= n; i++) {
            cin >> x[i] >> y[i];
        }

        for (int i = 1; i <= m; i++) {
          cin >> a[i] >> b[i];
        }
        
        cout << Mesi(n, m, x, y, a, b) << endl;

        delete[] x;
        delete[] y;
        delete[] a;
        delete[] b;
    }
    return 0;
}