#include <bits/stdc++.h>
#define MAXN 400007
#define MAXL 20
using namespace std;
int p[MAXL][MAXN], sz[MAXN], in[MAXN], out[MAXN], dfstime, g[MAXN][2];
bool leaf[MAXN];
void dfs(int s,int f) {
    p[0][s] = f;
    in[s] = dfstime++;
    if(!leaf[s]) {
        dfs(g[s][0],s);
        dfs(g[s][1],s);
        sz[s] = sz[g[s][0]] + sz[g[s][1]];
    } else sz[s] = 1;
    out[s] = dfstime++;
}
bool insub(int u, int v) {
    return in[u] >= in[v] && out[u] <= out[v];
}
int lca(int u, int v) {
    if(insub(u,v)) return v;
    if(insub(v,u)) return u;
    for(int i = MAXL - 1; i >= 0; i--) if(!insub(v, p[i][u])) u = p[i][u];
    return p[0][u];
}
bool cmp(int u,int v) {
    return in[u] < in[v];
}
void Nalbandian(int N,int Q,int* A,int* B,int* K, vector<int>* U,int* O) {
    int n = N,q = Q;
    assert(n <= 200000);
    assert(q <= 200000);
    for(int i = 1; i <= n; i++) leaf[i] = true;
    for(int i=1; i <= n-1; i++) {
        int t1,t2;
        assert(A[i] <= N + i - 1);
        assert(B[i] <= N + i - 1);
        assert(B[i] != A[i]);
        g[n + i][0] = A[i];
        g[n + i][1] = B[i];
    }
    dfs(2*n - 1, 2*n - 1);
    for(int j = 1; j < MAXL; j++) for(int i = 1; i <= 2*n - 1; i++) p[j][i] = p[j - 1][p[j - 1][i]];
    int sum = 0;
    for(int r = 1; r <= Q; r++) {
        int t = K[r];
        sum += t;
        vector<int> v, lc;
        for(int i = 1; i <= t; i++) {
            int tmp = U[r][i];
            assert(tmp>=1 && tmp<=n);
            v.push_back(tmp);
        }
        if(t == 1) {
            O[r] = n - 1;
            continue;
        }
        sort(v.begin(), v.end(), cmp);
        for (int i = 0; i < t - 1; i++) assert(v[i] != v[i + 1]);
        for (int i = 0; i < t - 1; i++) lc.push_back(lca(v[i], v[i + 1]));
        sort(lc.begin(),lc.end(), cmp);
        bool bad = false;
        for(int i = 0; i < t - 2; i++) if(!insub(lc[i + 1], lc[i])) bad = true;
        if(bad) O[r] = 0;
        else O[r] = sz[lc[lc.size() - 1]] - 2;
    }
    assert(sum<=1000000);
}