#include <bits/stdc++.h>
using namespace std;

const int N = 100010;

struct {
  int st[N * 4], lazy[N * 4];

  void push(int node, int tl, int tr) {
    if(!lazy[node]) return;
    if(lazy[node] == 1) st[node] = 0;
    else st[node] = tr - tl + 1;
    if(tl != tr) {
      lazy[node * 2] = lazy[node];
      lazy[node * 2 + 1] = lazy[node];
    }
    lazy[node] = 0;
  }

  void update(int node, int tl, int tr, int l, int r, int x) {
    push(node, tl, tr);
    if(tl > r ||  tr < l) return;
    if(tl >= l && tr <= r) {
      lazy[node] = x;
      push(node, tl, tr);
      return;
    }
    int mid = tl + tr >> 1;
    update(node * 2, tl, mid, l, r, x);
    update(node * 2 + 1, mid + 1, tr, l, r, x);
    st[node] = st[node * 2] + st[node * 2 + 1];
  }

  int query(int node, int tl, int tr, int l, int r) {
    push(node, tl, tr);
    if(tl > r || tr < l) return 0;
    if(tl >= l && tr <= r) return st[node];
    int mid = tl + tr >> 1;
    return query(node * 2, tl, mid, l, r) + query(node * 2 + 1, mid + 1, tr, l, r);
  }
} seg[11];

int st[N * 4], lazy[N * 4];

void push(int node, int tl, int tr) {
  if(!lazy[node]) return;
  st[node] = lazy[node];
  if(tl != tr) {
    lazy[node * 2] = lazy[node];
    lazy[node * 2 + 1] = lazy[node];
  }
  lazy[node] = 0;
}

void update(int node, int tl, int tr, int l, int r, int x) {
  push(node, tl, tr);
  if(tl > r || tr < l) return;
  if(tl >= l && tr <= r) {
    lazy[node] = x;
    push(node, tl, tr);
    return;
  }
  int mid = tl + tr >> 1;
  update(node * 2, tl, mid, l, r, x);
  update(node * 2 + 1, mid + 1, tr, l, r, x);
  st[node] = min(st[node * 2], st[node * 2 + 1]);
}

int query(int node, int tl, int tr, int l, int r) {
  push(node, tl, tr);
  if(tl > r || tr < l) return 1e6;
  if(tl >= l && tr <= r) return st[node];
  int mid = tl + tr >> 1;
  return min(query(node * 2, tl, mid, l, r), query(node * 2 + 1, mid + 1, tr, l, r));
}

int Vrednost(int N,int *A,int Q,int *T,int *L,int *R,int K) {
  int *a = A;
  bool ten = true;
  for(int i = 1; i <= N; i++) if(A[i] > 10) ten = false;
  if(max(N, Q) <= 5000) {
    for(int i = 1; i <= Q; i++) {
      if(T[i] == 1) {
        sort(A + L[i], A + R[i] + 1);
      } else if(T[i] == 2) {
        sort(A + L[i], A + R[i] + 1, greater<int>());
      } else {
        vector<int> v;
        for(int j = L[i]; j <= R[i]; j++) v.push_back(A[j]);
        sort(v.begin(), v.end());
        reverse(v.begin(), v.end());
        int l = L[i], r = R[i], j = 0;
        while(l < r) {
          if(!j) {
            A[l++] = v.back();
            v.pop_back();
          } else {
            A[r--] = v.back();
            v.pop_back();
          }
          j ^= 1;
        }
        if(l == r) A[l] = v.back();
      }
    }
    return A[K];
  }
  if(ten) {
    int n = N;
    for(int i = 1; i <= N; i++) seg[a[i]].update(1, 1, n, i, i, 2);
    for(int i = 1; i <= Q; i++) {
      int l = L[i], r = R[i];
      if(T[i] == 1) {
        vector<int> cnt(11);
        for(int j = 1; j <= 10; j++) cnt[j] = seg[j].query(1, 1, n, L[i], R[i]);
        for(int j = 1; j <= 10; j++) seg[j].update(1, 1, n, l, r, 1);
        int p = l;
        for(int j = 1; j <= 10; j++) {
          if(!cnt[j]) continue;
          seg[j].update(1, 1, n, p, p + cnt[j] - 1, 2);
          p += cnt[j];
        }
      } else if(T[i] == 2) {
        vector<int> cnt(11);
        for(int j = 1; j <= 10; j++) cnt[j] = seg[j].query(1, 1, n, L[i], R[i]);
        for(int j = 1; j <= 10; j++) seg[j].update(1, 1, n, l, r, 1);
        int p = l;
        for(int j = 10; j >= 1; j--) {
          if(!cnt[j]) continue;
          seg[j].update(1, 1, n, p, p + cnt[j] - 1, 2);
          p += cnt[j];
        }
      } else {
        vector<int> cnt(11);
        for(int j = 1; j <= 10; j++) cnt[j] = seg[j].query(1, 1, n, L[i], R[i]);
        for(int j = 1; j <= 10; j++) seg[j].update(1, 1, n, l, r, 1);
        int p = l, s = r;
        int cur = 0;
        for(int j = 1; j <= 10; j++) {
          if(!cnt[j]) continue;
          int up = (cnt[j] + 1) / 2, down = cnt[j] / 2;
          if(down > 0) {
            seg[j].update(1, 1, n, p, p + down - 1, 2);
            p += down;
            seg[j].update(1, 1, n, s - down + 1, s, 2);
            s -= down;
          }
          if(cnt[j] & 1) {
            if(!cur) seg[j].update(1, 1, n, p, p, 2), p++;
            else seg[j].update(1, 1, n, s, s, 2), s--;
            cur ^= 1;
          }
        }
      }
    }
    int ans = 0;
    for(int i = 1; i <= 10; i++) if(seg[i].query(1, 1, n, K, K) > 0) ans = i;
    assert(ans > 0);
    return ans;
  }
  bool ok = true;
  for(int i = 1; i <= Q; i++) {
    if(K != 1 || T[i] != 1) ok = false;
  }
  if(ok) {
    for(int i = 1; i <= N; i++) update(1, 1, N, i, i, A[i]);
    for(int i = 1; i <= Q; i++) {
      update(1, 1, N, L[i], R[i], query(1, 1, N, L[i], R[i]));
    }
    return query(1, 1, N, 1, 1);
  }
  bool only = true;
  for(int i = 1; i <= Q; i++) if(T[i] == 3) only = false;
  set<int> sa, sb;
  for(int i = 1; i < N; i++) {
    if(a[i] < a[i + 1]) sa.insert(i);
    else sb.insert(i);
  }
  for(int i = 1; i <= Q; i++) {
    vector<int> veca, vecb;
    auto lba = sa.lower_bound(L[i]);
    while(lba != sa.end() && *lba <= R[i]) {
      veca.push_back(*lba);
      lba++;
    }
    auto lbb = sb.lower_bound(L[i]);
    while(lbb != sb.end() && *lbb <= R[i]) {
      vecb.push_back(*lbb);
      lbb++;
    }
    for(int x : veca) sa.erase(x);
    for(int x : vecb) sb.erase(x);
    if(T[i] == 1) {
      sa.insert(L[i]);
    } else {
      sb.insert(L[i]);
    }
    if(R[i] < N) {
      sa.insert(R[i] + 1);
      sb.insert(R[i] + 1);
    }
  }
  vector<pair<int, int>> ev;
  for(int x : sa) ev.push_back({x, 1});
  for(int x : sb) ev.push_back({x, 2});
  sort(ev.begin(), ev.end());
  for(int i = 0; i < ev.size() - 1; i++) {
    sort(A + ev[i].first, A + ev[i + 1].first);
    if(ev[i].second == 2) reverse(A + ev[i].first, A + ev[i + 1].first);
  }
  int m = ev.size();
  sort(A + ev[m - 1].first, A + N + 1);
  if(ev[m - 1].second == 2) reverse(A + ev[m - 1].first, A + N + 1);
  for(int i = 1; i <= N; i++) cout << A[i] << " ";
  cout << endl;
  return A[K];
}
/*
5
2 4 3 1 5
5
2 1 3
2 2 5
1 1 2
1 4 5
2 3 4
4

4 5 3 1 2

5
3 4 5 2 1
2
1 4 5
1 2 4
1 1 2
*/