#include <bits/stdc++.h>

using namespace std;

const long long int inf = 1e18 + 48245;


struct pt{
    int x = 0;
    int y = 0;
    pt(){
        x = 0;
        y = 0;
    }
    pt(int x, int y): x(x), y(y){}
};


vector<vector<int>> adjs;
vector<pt> points;
vector<bool> visited;
int ans = 5;


long long int surf(pt p1, pt p2, pt p3){
    pt v1(p2.x - p1.x, p2.y - p1.y);
    pt v2(p3.x - p2.x, p3.y - p2.y);
    return v1.x * 1LL * v2.y - v1.y * 1LL * v2.x;
}

void dfs(int node, int prv, int d){
    // cout << "stuck with node: " << node << endl;
    if (d == 5) return;
    visited[node] = true;
    long long int c_surf, smallest_surf = inf;
    int smallest_surf_child = -1;
    vector<int> children;
    for (int child : adjs[node]) if (child != prv){
        if (prv == 0){
            dfs(child, node, d + 1);
        }
        else{
            if (visited[child]){
                // if (d == 2) cout << prv << "->" << node << "->" << child << endl;
                ans = min(ans, d);
            }
            else{
                c_surf = surf(points[prv], points[node], points[child]);
                if (c_surf <= 0) children.push_back(child);
                // reuse and remove
                /*
                c_surf = surf(points[prv], points[node], points[child]);
                if (c_surf < smallest_surf){
                    smallest_surf = c_surf;
                    smallest_surf_child = child;
                }
                */
            }
        }
    }
    sort(children.begin(), children.end(), [&points, &node](int a, int b){
        long long int sf = surf(points[node], points[b], points[a]);
        return (sf < 0);
    });

    // for (int child : children) dfs(child, node, d + 1);

    if (prv != 0 && children.size() != 0){
        dfs(children[0], node, d + 1);
    }
    visited[node] = false;
}


int Mesi(int n, int m, int* x, int* y, int* a, int* b){
    adjs.assign(n + 1, vector<int>(0));
    points.push_back(pt(0, 0));
    visited.push_back(false);
    for (int i = 1; i <= n; i++){
        points.push_back(pt(x[i], y[i]));
        visited.push_back(false);
    }
    for (int i = 1; i <= m; i++){
        adjs[a[i]].push_back(b[i]);
        adjs[b[i]].push_back(a[i]);
    }
    ans = 5;
    for (int i = 1; i <= n; i++){
        dfs(i, 0, 1);
    }
    points.clear();
    adjs.clear();
    visited.clear();
    return ans;
}