#include <bits/stdc++.h>

using namespace std;

const long long int inf = 2e18 + 48245;


struct pt{
    int x = 0;
    int y = 0;
    pt(){
        x = 0;
        y = 0;
    }
    pt(int x, int y): x(x), y(y){}
};


vector<vector<int>> adjs;
vector<pt> points;
vector<bool> visited;
int ans = 5;


long long int surf(pt p1, pt p2, pt p3){
    pt v1(p2.x - p1.x, p2.y - p1.y);
    pt v2(p3.x - p2.x, p3.y - p2.y);
    return v1.x * 1LL * v2.y - v1.y * 1LL * v2.x;
}

void dfs(int node, int prv, int d){
    // cout << "stuck with node: " << node << endl;
    if (d == 5) return;
    visited[node] = true;
    long long int c_surf;
    int smallest_negative = -1;
    int smallest_positive = -1;
    for (int child : adjs[node]) if (child != prv){
        if (prv == 0){
            dfs(child, node, d + 1);
        }
        else{
            if (visited[child]){
                ans = min(ans, d);
            }
            else{
                c_surf = surf(points[prv], points[node], points[child]);
                if (c_surf <= 0LL){
                    if (smallest_negative == -1) smallest_negative = child;
                    else if (surf(points[node], points[child], points[smallest_negative]) > 0LL)
                        smallest_negative = child;
                }
                else{
                    if (smallest_positive == -1) smallest_positive = child;
                    else if (surf(points[node], points[child], points[smallest_positive]) > 0LL)
                        smallest_positive = child;
                }
            }
        }
    }
    if (prv != 0){
        if (smallest_negative != -1) dfs(smallest_negative, node, d + 1);
        else if (smallest_positive != -1) dfs(smallest_positive, node, d + 1);
    }
    visited[node] = false;
}


int Mesi(int n, int m, int* x, int* y, int* a, int* b){
    adjs.assign(n + 1, vector<int>(0));
    points.push_back(pt(0, 0));
    visited.push_back(false);
    for (int i = 1; i <= n; i++){
        points.push_back(pt(x[i], y[i]));
        visited.push_back(false);
    }
    for (int i = 1; i <= m; i++){
        adjs[a[i]].push_back(b[i]);
        adjs[b[i]].push_back(a[i]);
    }
    ans = 5;
    for (int i = 1; i <= n; i++){
        dfs(i, 0, 1);
    }
    points.clear();
    adjs.clear();
    visited.clear();
    return ans;
}