#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)

const int N = 103;
vector<int> adj[N];
int dist[N];
int n;
map<pair<int, int>, bool> mp;

void Dijkstra(int j) {
    for (int i = 1; i <= n; i++) dist[i] = 1e9;
    dist[j] = 0;
    priority_queue<pair<int, int>, vector<pair<int, int>>, greater<>> pq;
    pq.emplace(0, j);
    while (!pq.empty()) {
        auto [w, u] = pq.top(); pq.pop();
        if (dist[u] < w) continue;
        for (auto x : adj[u]) if (!mp[{x, u}]) {
            if (dist[x] > w+1) {
                dist[x] = w+1;
                pq.emplace(dist[x], x);
            }
        }
    }
}

int Mesi(int N, int m, int* x, int* y, int* a, int* b) {
    n = N;
    mp.clear();
    for (int i = 0; i <= n; i++) adj[i].clear();
    for (int i = 1; i <= m; i++) {
        adj[a[i]].push_back(b[i]);
        adj[b[i]].push_back(a[i]);
    }
    int ans = 1e9;
    for (int i = 1; i <= n; i++) {
        for (auto x : adj[i]) {
            mp[{i, x}] = true;
            mp[{x, i}] = true;
            Dijkstra(i);
            mp[{i, x}] = false;
            mp[{x, i}] = false;
            int res = dist[x]+1;
            ans = min(ans, res);
        }
    }

    return ans;
}