#include <bits/stdc++.h>
using namespace std;
typedef long long ll;
void DBG() { cerr << "]" << endl; }
template<class H, class... T> void DBG(H h, T... t) { cerr << to_string(h); if(sizeof...(t)) cerr << ", "; DBG(t...); }
#define dbg(...) cerr << "[" << #__VA_ARGS__ << "]: [", DBG(__VA_ARGS__)

const int N = 1e5 + 3;
const int NO_OPERATION = 0;
int sum[4*N], operation[4*N];
int b[N];

struct segTree {
    void propagate(int x, int lx, int rx) {
        if (rx - lx == 1 || operation[x] == NO_OPERATION) return;
        int m = (lx + rx) / 2;
        operation[x * 2 + 1] = operation[x];
        operation[x * 2 + 2] = operation[x];
        sum[x * 2 + 1] = operation[x] * (m - lx);
        sum[x * 2 + 2] = operation[x] * (rx - m);
        operation[x] = NO_OPERATION;
    }

    void assignn(int x, int lx, int rx, int l, int r, int v) {
        if (l >= r) return;
        propagate(x, lx, rx);
        if (lx >= r || rx <= l) return;
        if (lx >= l && rx <= r) {
            operation[x] = v;
            sum[x] = v * (rx - lx);
            return;
        }
        int m = (lx + rx) / 2;
        assignn(x * 2 + 1, lx, m, l, r, v);
        assignn(x * 2 + 2, m, rx, l, r, v);

        sum[x] = sum[x * 2 + 1] + sum[x * 2 + 2];
    }

    int get(int x, int lx, int rx, int l, int r) {
        propagate(x, lx, rx);
        if (lx >= r || rx <= l) return 0;
        if (lx >= l && rx <= r) {
            return sum[x];
        }

        int m = (lx + rx) / 2;
        int s1 = get(x * 2 + 1, lx, m, l, r);
        int s2 = get(x * 2 + 2, m, rx, l, r);

        return s1 + s2;
    }
};
segTree seg;

int Vrednost(int n,int *A,int q,int *T,int *L,int *R,int k) {
    int low = 1, high = 1e9;
    while (low < high) {
        int m = (low + high) / 2;
        for (int i = 0; i < 4*N; i++) sum[i] = 0, operation[i] = NO_OPERATION;
        for (int i = 1; i <= n; i++) {
            b[i] = (A[i] <= m ? 0 : 1);
            seg.assignn(0, 1, n+1, i, i+1, b[i]);
        }
        for (int i = 1; i <= q; i++) {
            if (T[i] == 1) {
                int l = L[i], r = R[i];
                int sm = seg.get(0, 1, n+1, l, r+1);
                int rr = r-sm;
                seg.assignn(0, 1, n+1, l, rr+1, 0);
                seg.assignn(0, 1, n+1, rr+1, r+1, 1);
            } else if (T[i] == 2) {
                int l = L[i], r = R[i];
                int sm = seg.get(0, 1, n+1, l, r+1);
                int rr = l+sm;
                seg.assignn(0, 1, n+1, l, rr, 1);
                seg.assignn(0, 1, n+1, rr, r+1, 0);
            }
        }
        if (seg.get(0, 1, n+1, k, k+1) == 0)
            high = m;
        else
            low = m+1;
    }
    return low;
}