#include <bits/stdc++.h>
using namespace std;

#define ios cin.tie(0); cout.tie(0); //ios_base.Init(); iostream.clear();
#define ll long long
#define mxn 5002

struct seg_tree
{
    ll m,t;
    vector <ll> st,lazy;

    void Init( int n )
    {
        m = 1;
        while ( m < n )
        {
            m *= 2;
        }
        st.resize(2*m+4,0);
        lazy.resize(2*m+4,-1);
    }

    void Build( int n, int *A )
    {
        for ( ll i = m; i < m+n; i++ )
        {
            st[i] = (A[i-m+1]==t);
        }
        for ( ll i = m+n; i <= 2*m-1; i++ )
        {
            st[i] = 0;
        }
        for ( ll i = m-1; i >= 1; i-- )
        {
            st[i] = st[2*i]+st[2*i+1];
        }
    }

    void Propagate( ll x )
    {
        if ( lazy[x] < 0 )
        {
            return;
        }
        st[x] = lazy[x];
        if ( x >= m )
        {
            lazy[x] = -1;
            return;
        }
        lazy[2*x] = lazy[2*x+1] = lazy[x]/2;
        lazy[x] = -1;
    }

    void Update( ll l, ll r, ll v, ll x, ll lx, ll rx )
    {
        if ( rx < l || lx > r )
        {
            return;
        }
        Propagate(x);
        if ( l <= lx && rx <= r )
        {
            lazy[x] = v*(rx-lx+1);
            Propagate(x);
            //lazy[2*x] = lazy[2*x+1] = v*((rx-lx+1)/2);
            return;
        }
        ll mid = (lx+rx)/2;
        Update(l,r,v,2*x,lx,mid);
        Update(l,r,v,2*x+1,mid+1,rx);
        st[x] = st[2*x]+st[2*x+1];
    }

    ll Query( ll l, ll r, ll x, ll lx, ll rx )
    {
        if ( rx < l || lx > r )
        {
            return 0;
        }
        Propagate(x);
        if ( l <= lx && rx <= r )
        {
            return st[x];
        }
        ll mid = (lx+rx)/2;
        ll q1 = Query(l,r,2*x,lx,mid);
        ll q2 = Query(l,r,2*x+1,mid+1,rx);
        return q1+q2;
    }

    void Prikazi()
    {
        for ( ll i = 1; i < 2*m; i++ )
        {
            cout << st[i] << " ";
        }
        cout << "\n";
        for ( ll i = 1; i < 2*m; i++ )
        {
            cout << lazy[i] << " ";
        }
        cout << "\n";
    }
};

void Rasengan( ll n, ll l, ll r, int* A )
{
    int B[r+1];
    for ( ll i = 1; i <= r; i++ )
    {
        B[i] = A[i];
    }
    sort(B+l,B+r+1);
    ll i=l,j=r,b=l,p=0;
    while ( b <= r )
    {
        if ( !p )
        {
            A[i++] = B[b++];
            p ^= 1;
            continue;
        }
        A[j--] = B[b++];
        p ^= 1;
    }
//    for ( ll i = 1; i <= n; i++ )
//    {
//        cout << A[i] << " ";
//    }
//    cout << "\n";
}

int Podzadatak123( int n, int *A, int q, int *T, int *L, int *R, int k )
{
    for ( ll i = 1; i <= q; i++ )
    {
        ll l=L[i],r=R[i];
        if ( T[i] == 1 )
        {
            sort(A+l,A+r+1);
            continue;
        }
        if ( T[i] == 2 )
        {
            sort(A+l,A+r+1,greater<ll>());
            continue;
        }
        Rasengan(n,l,r,A);
    }
    return A[k];
}

int Podzadatak4( int n, int *A, int q, int *T, int *L, int *R, int k )
{
    ll m=1,minn=INT_MAX;
    for ( ll i = 1; i <= n; i++ )
    {
        if ( minn < A[i] )
        {
            minn = A[i];
            m = i;
        }
    }
    for ( ll i = 1; i <= q; i++ )
    {
        ll l=L[i],r=R[i];
        if ( T[i] == 1 )
        {
            sort(A+l,A+r+1);
            continue;
        }
        if ( T[i] == 2 )
        {
            sort(A+l,A+r+1,greater<ll>());
            continue;
        }
        Rasengan(n,l,r,A);
    }
    return A[k];
}

int Podzadatak56( int n, int *A, int q, int *T, int *L, int *R, int k )
{
    seg_tree seg[11];
    for ( ll i = 1; i <= 10; i++ )
    {
        seg[i].Init(n);
        seg[i].t = i;
        seg[i].Build(n,A);
    }
    for ( ll i = 1; i <= q; i++ )
    {
        ll l=L[i],r=R[i],pl=l,pr=r;
        if ( T[i] == 1 )
        {
            for ( ll j = 1; j <= 10; j++ )
            {
                ll br = seg[j].Query(l,r,1,1,seg[j].m);
                if ( br == 0 )
                {
                    continue;
                }
                seg[j].Update(l,r,0,1,1,seg[j].m);
                //cout << j << ":\n";
                //seg[j].Prikazi();
                seg[j].Update(pl,pl+br-1,1,1,1,seg[j].m);
                //seg[j].Prikazi();
                pl += br;
            }
            continue;
        }
        if ( T[i] == 2 )
        {
            for ( ll j = 1; j <= 10; j++ )
            {
                ll br = seg[j].Query(l,r,1,1,seg[j].m);
                if ( br == 0 )
                {
                    continue;
                }
                seg[j].Update(l,r,0,1,1,seg[j].m);
                seg[j].Update(pr-br+1,pr,1,1,1,seg[j].m);
                pr -= br;
            }
            continue;
        }
        for ( ll j = 1; j <= 10; j++ )
        {
            ll br = seg[j].Query(l,r,1,1,seg[j].m);
            if ( br == 0 )
            {
                continue;
            }
            seg[j].Update(l,r,0,1,1,seg[j].m);
            seg[j].Update(pr-br+1,pr,1,1,1,seg[j].m);
            pr -= br;
        }
    }

    for ( ll j = 1; j <= 10; j++ )
    {
        if ( seg[j].Query(k,k,1,1,seg[j].m) )
        {
            return j;
        }
    }
    return 1;
}

int Vrednost( int n, int *A, int q, int *T, int *L, int *R, int k )
{
//    if ( n > 5000 || q > 5000 )
//    {
//        return 1;
//    }
    if ( n <= 1 && q <= 1 )
    {
        return Podzadatak123(n,A,q,T,L,R,k);
    }
    return Podzadatak56(n,A,q,T,L,R,k);
}