#include <bits/stdc++.h>
#define ll long long
using namespace std;
ll sz=1,n;
struct seg_tree
{
    vector<ll> st,lazy;
    void Init()
    {
        while (sz<n)
            sz <<= 1;
        st.resize(2*sz+2);
        lazy.resize(2*sz+2);
    }
    void Build()
    {
        for (ll i=sz;i<sz+n;i++)
            st[i]=i-sz+1;
        for (ll i=sz-1;i>=0;i--)
            st[i]=max(st[2*i],st[2*i+1]);
    }
    void Propagate(ll x)
    {
        st[x]=max(st[x],lazy[x]);
        if (x<sz)
        {
            lazy[2*x]=max(lazy[2*x],lazy[x]);
            lazy[2*x+1]=max(lazy[2*x+1],lazy[x]);
        }
        lazy[x]=0;
    }
    void Update(ll l,ll r,ll val,ll x,ll lx,ll rx)
    {
        Propagate(x);
        if (lx>r || rx<l)
            return;
        if (lx>=l && rx<=r)
        {
            lazy[x]=val;
            Propagate(x);
            return;
        }
        ll mid=(lx+rx)/2;
        Update(l,r,val,2*x,lx,mid);
        Update(l,r,val,2*x+1,mid+1,rx);
        st[x]=max(st[2*x],st[2*x+1]);
    }
    ll Calc(ll l,ll r,ll x,ll lx,ll rx)
    {
        Propagate(x);
        if (lx>r || rx<l)
            return 0;
        if (lx>=l && rx<=r)
            return st[x];
        ll mid=(lx+rx)/2;
        return max(Calc(l,r,2*x,lx,mid),Calc(l,r,2*x+1,mid+1,rx));
    }
    void Show()
    {
        for (ll i : st)
            cout << i << " ";
        cout << "\n";
    }
};
int Vrednost(int N,int *A,int Q,int *T,int *L,int *R,int K) {
    /*if (N<=5000 && Q<=5000)
    {
        vector<ll> a;
        for (ll i=1;i<=N;i++)
            a.push_back(A[i]);
        for (ll i=1;i<=Q;i++)
        {
            if (T[i]==1)
                sort(a.begin()+L[i]-1,a.begin()+R[i]);
            else if (T[i]==2)
                sort(a.begin()+L[i]-1,a.begin()+R[i],greater<ll>());
            else
            {
                vector<ll> b;
                for (ll j=L[i]-1;j<R[i];j++)
                    b.push_back(a[j]);
                sort(b.begin(),b.end());
                ll l=L[i]-1,r=R[i]-1;
                for (ll i=1;i<=b.size();i++)
                {
                    if (i&1)
                    {
                        a[l]=b[i-1];
                        l++;
                    }
                    else
                    {
                        a[r]=b[i-1];
                        r--;
                    }
                }
            }
        }
        return a[K-1];
    }*/
    n=N;
    bool zad4=true;
    for (ll i=1;i<=Q;i++)
    {
        if (T[i]!=1)
            zad4=false;
    }
    if (zad4 && K==1)
    {
        seg_tree S;
        S.Init();
        S.Build();
        for (ll i=1;i<=Q;i++)
        {
            ll val=S.Calc(L[i],R[i],1,1,sz);
            S.Update(L[i],R[i],val,1,1,sz);
        }
        ll maxx=S.Calc(1,1,1,1,sz);
        ll ans=LLONG_MAX;
        for (ll i=1;i<=maxx;i++)
            ans=min(ans,(ll)A[i]);
        return ans;
    }
}