#include<bits/stdc++.h>
using namespace std;

const int N = 2e5 + 10;

struct DSU {
  int par[N], siz[N];
  void init(int n) {
    for(int i = 1; i <= n; i++) par[i] = i, siz[i] = 1;
  }
  int get(int x) {
    return (x == par[x] ? x : get(par[x]));
  }
  void unite(int u, int v) {
    u = get(u); v = get(v);
    if(u == v) return;
    if(siz[u] > siz[v]) swap(u, v);
    par[u] = v;
    siz[v] += siz[u];
  }
  bool same(int u, int v) {
    return (get(u) == get(v));
  }
  int query(int x) {
    return siz[get(x)];
  }
};

void Nalbandian(int N, int Q, int* A, int* B, int* K, vector<int>* U, int* O) {
  DSU dsu;
  dsu.init(N);
  for(int i = 1; i < N; i++) {
    vector<int> va, vb;
    if(A[i] <= N) {
      va.push_back(A[i]);
    } else {
      va.push_back(A[A[i] - N]);
      va.push_back(B[A[i] - N]);
    }
    if(B[i] <= N) {
      vb.push_back(B[i]);
    } else {
      vb.push_back(A[B[i] - N]);
      vb.push_back(B[B[i] - N]);
    }
    for(int x : va) {
      for(int y : vb) dsu.unite(x, y);
    }
  }
  map<int, int> mp;
  for(int i = 1; i < N; i++) {
    mp[A[i]] = B[i];
    mp[B[i]] = A[i];
  }
  for(int i = 1; i <= Q; i++) {
    int k = K[i];
    vector<int> v = U[i];
    bool ok = true;
    for(int j = 2; j <= K[i]; j++) if(!dsu.same(U[i][j], U[i][j - 1])) ok = false;
    map<int, bool> was;
    for(int j = 1; j <= K[i]; j++) {
      if(was[mp[U[i][j]]]) ok = false;
      was[U[i][j]] = true;
    }
    if(!ok) {
      O[i] = 0;
    } else {
      O[i] = dsu.query(U[i][1]) - k;
    }
  }
  return;
}
/*
4 4
1 2
3 4
5 6
2
1 3
3
1 2 3
1
2
2
1 2
*/