#include<bits/stdc++.h>
using namespace std;

const int N = 2e5 + 10;

const int inf = 1e9;

int dp[N], ls[N], rs[N];

void Dfs(int x, int par) {
  if(ls[x] == 0 && rs[x] == 0) return;
  if(ls[x] > 0) Dfs(ls[x], x);
  if(rs[x] > 0) Dfs(rs[x], x);
  if(ls[x] > 0 && rs[x] > 0 && dp[ls[x]]== 0 && dp[rs[x]] == 0) dp[x] = -inf;
  else dp[x] = dp[ls[x]] + dp[rs[x]];
}

struct DSU {
  int par[N], siz[N];
  void init(int n) {
    for(int i = 1; i <= n; i++) par[i] = i, siz[i] = 1;
  }
  int get(int x) {
    return (x == par[x] ? x : get(par[x]));
  }
  void unite(int u, int v) {
    u = get(u); v = get(v);
    if(u == v) return;
    if(siz[u] > siz[v]) swap(u, v);
    par[u] = v;
    siz[v] += siz[u];
  }
  bool same(int u, int v) {
    return (get(u) == get(v));
  }
  int query(int x) {
    return siz[get(x)];
  }
};

void Nalbandian(int N, int Q, int* A, int* B, int* K, vector<int>* U, int* O) {
  DSU dsu;
  dsu.init(N);
  for(int i = 1; i < N; i++) {
    ls[i + N] = A[i];
    rs[i + N] = B[i];
  }
  for(int i = 1; i <= Q; i++) {
    int k = K[i];
    vector<int> v = U[i];
    for(int j = 1; j <= N * 2; j++) dp[j] = 0;
    for(int j = 1; j <= N; j++) dp[j] = 1;
    for(int j = 1; j <= K[i]; j++) dp[U[i][j]] = 0;
    Dfs(2 * N - 1, 0);
    if(dp[2 * N - 1] < 0) O[i] = 0;
    else O[i] = dp[2 * N - 1];
  }
  return;
}
/*
4 4
1 2
3 4
5 6
2
1 3
3
1 2 3
1
2
2
1 2
*/