#include<bits/stdc++.h>
using namespace std;

const int N = 4e5 + 10;

const int inf = 1e9;

const int LOG = 25;

vector<int> g[N];
int dp[N], up[N][LOG], in[N], out[N], timer = 0, n;

void dfs(int x, int par) {
  if(x <= n) return;
  for(int j :  g[x]) {
    if(j != par) {
      dfs(j, x);
      dp[x] += dp[j];
    }
  }
  if(!dp[x]) dp[x] = -inf;
}

void Dfs(int x, int par) {
  up[x][0] = par;
  in[x] = ++timer;
  for(int j = 1; j < LOG; j++) up[x][j] = up[up[x][j - 1]][j - 1];
  for(int j : g[x]) {
    if(j != par) {
      Dfs(j, x);
    }
  }
  out[x] = timer;
}

bool In(int u, int v) {
  return (in[u] <= in[v] && out[u] >= out[v]);
}

int Lca(int u, int v) {
  if(In(u, v)) return u;
  if(In(v, u)) return v;
  for(int j = LOG - 1; j >= 0; j--) {
    if(up[u][j] > 0 && !In(up[u][j], v)) u = up[u][j];
  }
  return up[u][0];
}

struct DSU {
  vector<int> par, siz;
  void init(int n) {
    par.resize(n + 1);
    siz.resize(n + 1);
    for(int i = 1; i <= n; i++) par[i] = i, siz[i] = 1;
  }
  int get(int x) {
    return (x == par[x] ? x : get(par[x]));
  }
  void unite(int u, int v) {
    u = get(u); v = get(v);
    if(u == v) return;
    if(siz[u] > siz[v]) swap(u, v);
    par[u] = v;
    siz[v] += siz[u];
  }
  bool same(int u, int v) {
    return (get(u) == get(v));
  }
  int query(int x) {
    return siz[get(x)];
  }
};

void Nalbandian(int N, int Q, int* A, int* B, int* K, vector<int>* U, int* O) {
  n = N;
  DSU dsu;
  dsu.init(N * 2);
  for(int i = 1; i < N; i++) {
    g[A[i]].push_back(i + N);
    g[i + N].push_back(A[i]);
    g[B[i]].push_back(i + N);
    g[i + N].push_back(B[i]);
    dsu.unite(A[i], i + N);
    dsu.unite(B[i], i + N);
  }
  if(max(N, Q) > 500) return;
  /*for(int j = N * 2; j >= 1; j--) if(!in[j]) Dfs(j, 0);
  for(int i = 1; i <= Q; i++) {
    int k = K[i];
    vector<int> v = U[i];
    int lc = U[i][1];
    for(int j = 2; j <= K[i]; j++) lc = Lca(lc, U[i][j]);
    for(int j = 1; j <= N * 2; j++) dp[j] = 0;
    for(int j = 1; j <= N; j++) dp[j] = 1;
    for(int j = 1; j <= K[i]; j++) dp[U[i][j]] = 0;
    cout << "dbg " << lc << endl;
    for(int j = 1; j <= n * 2; j++) cout << dp[j] << " ";
    cout << endl;
    dfs(lc, 0);
    O[i] = (dp[lc] < 0 ? 0 : dp[lc]);
  }
  return;*/
  for(int i = 1; i <= Q; i++) {
    int ans = 0;
    for(int j = 1; j <= N; j++) {
      bool ok = true;
      for(int o = 1; o <= K[i]; o++) {
        if(j == U[i][o]) ok = false;
        if(!dsu.same(j, U[i][o])) ok = false;
      }
      if(ok) ans++;
    }
    bool ok = true;
    map<int, bool> was;
    for(int j = 1; j <= K[i]; j++) was[U[i][j]] = true;
    for(int j = 1; j < N; j++) {
      if(was[A[j]] && was[B[j]]) ok = false;
    }
    if(!ok) O[i] = 0;
    else O[i] = ans;
  }
}
/*
4 4
1 2
3 4
5 6
2
1 3
3
1 2 3
1
2
2
1 2
*/