#include<bits/stdc++.h>

using namespace std;

const int max_n = 2e5 + 5;
const int max_n2 = 2 * max_n;
const int max_d = 19;

int l[max_n2] = {0};
int r[max_n2] = {0};
int d[max_n2] = {0};
int leaves[max_n2] = {0};
int p[max_n2][max_d] = {0};
int tree[max_n2] = {0};
bool found[max_n2] = {0};
int n;

vector<int> adjs[max_n2];
vector<int> tour;


void dfs(int node, int prv){
    d[node] = d[prv] + 1;
    p[node][0] = prv;
    if (adjs[node].size() == 1) leaves[node] = 1;
    else leaves[node] = 0;
    l[node] = tour.size();
    tour.push_back(node);
    for (int child : adjs[node]) if (child != prv){
        dfs(child, node);
        leaves[node] += leaves[child];
    }
    r[node] = tour.size() - 1;
}


int lca(int u, int v){
    if (d[v] > d[u]) swap(u, v);
    int jump = max_d - 1;
    while (d[u] != d[v]){
        if (d[p[u][jump]] >= d[v]) u = p[u][jump];
        jump--;
    }
    if (u != v){
        jump = max_d - 1;
        while (p[u][0] != p[v][0]){
            if (p[u][jump] != p[v][jump]){
                u = p[u][jump];
                v = p[v][jump];
            }
            jump--;
        }
        u = p[u][0];
    }
    return u;
}


void update(int pos, int delta){
    for (int i = pos; i <= 2 * (n - 1); i |= (i + 1)) tree[i] += delta;
}


int pref(int r){
    int ans = 0;
    for (int i = r; i >= 0; i = (i & (i + 1)) - 1) ans += tree[i];
    return ans;
}


int query(int l, int r){
    int ans = pref(r);
    if (l != 0) ans -= pref(l - 1);
    return ans;
}


void Nalbandian(int N, int Q, int* A, int* B, int* K, vector<int>* U, int* O){
    // cout << (1 << 19) << endl;
    n = N;
    int on_node = N + 1;
    for (int i = 1; i < N; i++){
        adjs[A[i]].push_back(on_node);
        adjs[B[i]].push_back(on_node);
        adjs[on_node].push_back(A[i]);
        adjs[on_node].push_back(B[i]);
        on_node++;
    }
    dfs(2 * N - 1, 0);
    r[0] = r[2 * N - 1];
    for (int lvl = 1; lvl < max_d; lvl++){
        for (int i = 1; i < 2 * N; i++){
            p[i][lvl] = p[p[i][lvl - 1]][lvl - 1];
        }
    }
    for (int cq = 1; cq <= Q; cq++){
        for (int i = 1; i <= K[cq]; i++){
            update(l[U[cq][i]], 1);
        }
        vector<int> lcas;
        for (int i = 1; i <= K[cq]; i++){
            int jump = max_d - 1;
            int u = U[cq][i];
            for (int jump = max_d - 1; jump >= 0; jump--){
                if (query(l[p[u][jump]], r[p[u][jump]]) <= 1) u = p[u][jump];
            }
            if (u == 0) u = 2 * N - 1;
            if (query(l[p[u][0]], r[p[u][0]]) >= 2) u = p[u][0];
            // u je sada najdublji cvor koji sadrzi bar 2 setovana
            lcas.push_back(u);
        }
        bool valid = true;
        int lowest = lcas[0];
        for (int i = 1; i < lcas.size(); i++){
            int c_lca = lca(lowest, lcas[i]);
            if (c_lca == lowest){
                lowest = lcas[i];
            }
            else if (c_lca != lcas[i]) valid = false;
        }
        O[cq] = 0;
        if (valid){
            stack<int> to_reset;
            int duplicates = 0;
            for (int i = 1; i <= K[cq]; i++){
                int c_lca = lca(lowest, U[cq][i]);
                if (found[c_lca]){
                    duplicates++;
                }
                else{
                    to_reset.push(c_lca);
                    found[c_lca] = true;
                }
            }
            while (!to_reset.empty()){
                found[to_reset.top()] = false;
                to_reset.pop();
            }
            if (duplicates <= 1){
                O[cq] += leaves[lowest] - query(l[lowest], r[lowest]);
            }
        }
        for (int i = 1; i <= K[cq]; i++){
            update(l[U[cq][i]], -1);
        }
    }
    return;
}
/*
4
4
1 2
3 4
5 6
2 1 3
3 1 2 3
1 2
2 1 2
*/