#include <bits/stdc++.h>
#include <fstream>

using namespace std;

struct node
{
    int num;
    node* left;
    node* right;
};

unordered_map<int, node*> nodemap;
unordered_map<int, string> pathmap;

void make_path(node* head,string path)
{
    if(head->left == nullptr)
    {
        pathmap[head->num] = path;
    }
    else
    {
        make_path(head->left, path + "0");
    }

    if(head->right == nullptr)
    {
        pathmap[head->num] = path;
    }
    else
    {
        make_path(head->right, path + "1");
    }

    return;
}

const int MAX_N = 200100;
pair<int, string> pathniz[MAX_N];
int binaryManje(int key, int N)
{
    int l=1;
    int r=N;

    while(l < r)
    {
        int mid = (l + r) / 2;

        if(pathniz[mid].first == key)
        {
            return mid;
        }

        if(pathniz[mid].first > key)
        {
            r = mid - 1;
        }
        else
        {
            l = mid + 1;
        }
    }

    return r;
}

int binaryVece(int key, int N)
{
    int l=1;
    int r=N;

    while(l < r)
    {
        int mid = (l + r) / 2;

        if(pathniz[mid].first == key)
        {
            return mid;
        }

        if(pathniz[mid].first < key)
        {
            l = mid + 1;
        }
        else
        {
            r = mid - 1;
        }
    }

    return l;
}

bool binaryNadji(int key, int l, int r)
{
    while(l <= r)
    {
        //cout<<l<<" "<<r<<" "<<key<<endl;
        int mid = (l + r) / 2;

        if(pathniz[mid].first == key)
        {
            return true;
        }

        if(pathniz[mid].first < key)
        {
            l = mid + 1;
        }
        else
        {
            r = mid - 1;
        }
    }

    return false;
}

void Nalbandian(int N, int Q, int* A, int* B, int* K, std::vector<int>* U, int* O)
{
    for(int i=1;i<=N;i++)
    {
        node* a = new node;
        a->num = i;
        a->left = nullptr;
        a->right = nullptr;

        nodemap[i] = a;
    }

    for(int i=1;i<=N-1;i++)
    {
        node* a = new node;
        a->num = N+i;
        a->left = nodemap[A[i]];
        a->right = nodemap[B[i]];

        nodemap[N+i] = a;
    }

    node* head = nodemap[2*N-1];

    make_path(head, "");

    int st = log(N);
    if(st < log(N))
    {
        st++;
    }
    for(int i=1;i<=N;i++)
    {
        pathniz[i].second = pathmap[i];

        int value = 0;
        for(int j=0;j<=st;j++)
        {
            if((pathniz[i].second)[j] == '1')
            {
                value += pow(2, st-j);
            }
        }


        pathniz[i].first = value;
    }

    sort(pathniz + 1, pathniz + N + 1);

    for(int i=1;i<=Q;i++)
    {
        bool possible = true;
        string solution = "";

        int c0=0;
        int c1=0;
        int pos=0;

        while(pos<=log(N))
        {
            for(int j=1;j<=K[i];j++)
            {
                string path = pathmap[U[i][j]];

                if(path.substr(0, pos) != solution)
                {
                    continue;
                }

                if(path[pos] == '0')
                {
                    c0++;
                }
                else
                {
                    c1++;
                }
            }

            if(c0 > 1 and c1 > 1)
            {
                possible = false;
                //continue;
            }
            else
            {
                if(c0 <= 1 and c1 <= 1)
                {
                    solution += "_";
                    //continue;
                }
                else
                {
                    if(c0 > 1)
                    {
                        solution += "0";
                    }
                    else
                    {
                        solution += "1";
                    }
                }
            }

            pos++;
            c0=0;
            c1=0;
        }

        if(possible)
        {
            int lowerBound = 0; // Prvi veci ili jednak
            int upperBound = 0; // Prvi manji ili jednak

            for(int j=0;j<=st;j++)
            {
                if(solution[j] == '1')
                {
                    lowerBound += pow(2, st-j);
                    upperBound += pow(2, st-j);
                }
                else
                {
                    if(solution[j] != '0')
                    {
                        upperBound += pow(2, st-j);
                    }
                }
            }

            //cout<<lowerBound<<" "<<upperBound<<endl;
            int lowerBoundIndex = binaryVece(lowerBound, N);
            int upperBoundIndex = binaryManje(upperBound, N);
            //cout<<lowerBoundIndex<<" "<<upperBoundIndex<<endl;

            int rez = upperBoundIndex - lowerBoundIndex + 1;
            //cout<<"R: "<<rez<<endl;
            for(int j=1;j<=K[i];j++)
            {
                int kljuc = 0;
                string kljucS = pathmap[U[i][j]];
                //cout<<kljucS<<": ";
                for(int s=0;s<=st;s++)
                {
                    if(kljucS[s] == '1')
                    {
                        kljuc += pow(2, st-s);
                    }
                }//cout<<kljuc<<" "<<endl;

                if(binaryNadji(kljuc, lowerBoundIndex, upperBoundIndex))
                {
                    //cout<<"T"<<endl;
                    rez--;
                }//cout<<endl;
            }//cout<<endl;
            if(rez < 0)
            {
                rez = 0;
            }

            O[i] = rez;
        }
        else
        {
            O[i] = 0;
        }
    }
}

/*
int main() {
    int N, Q;
    scanf("%d %d", &N, &Q);

    int* A = new int[N + 1];
    int* B = new int[N + 1];
    int* K = new int[Q + 1];
    std::vector<int>* U = new std::vector<int>[Q + 1];
    int* O = new int[Q + 1];

    for (int i = 1; i < N; i++)
        scanf("%d %d", &A[i], &B[i]);

    for (int i = 1; i <= Q; i++) {
        scanf("%d", &K[i]);
        U[i].resize(K[i] + 1, 0);
        for (int j = 1; j <= K[i]; j++)
            scanf("%d", &U[i][j]);
    }

    Nalbandian(N, Q, A, B, K, U, O);

    for (int i = 1; i <= Q; i++)
        printf("%d\n", O[i]);

    delete[] A;
    delete[] B;
    delete[] K;
    delete[] U;
    delete[] O;

    return 0;
}*/