#include <bits/stdc++.h>
using namespace std;
const int MAXN = 4e5+5;
const int LOG = 18;


int n;
array<int,2> g[MAXN];
int d[MAXN];
int up[MAXN][LOG];
int c[MAXN];

void dfs(int x, int p){
    up[x][0] = p;
    for(int i = 1; i < LOG; ++i){
        up[x][i] = up[up[x][i-1]][i-1];
    }
    if(x > n){
        d[g[x][0]] = d[g[x][1]] = d[x]+1;
        dfs(g[x][0],x);
        dfs(g[x][1],x);
        c[x] = c[g[x][0]] + c[g[x][1]];
    }
    else c[x] = 1;
}
int lift(int x, int k){
    for(int i = 0; i < LOG; ++i){
        if(k&(1<<i)) x = up[x][i];
    }
    return x;
}
int lca(int x, int y){
    if(d[x] < d[y]) swap(x,y);
    x = lift(x,d[x]-d[y]);
    if(x==y) return x;
    for(int i = LOG-1; i >= 0; --i){
        if(up[x][i] != up[y][i]){
            x = up[x][i];
            y = up[y][i];
        }
    }
    return up[x][0];
}

void Nalbandian(int N, int Q, int* A, int* B, int* K, std::vector<int>* U, int* O){
    n = N;
    for(int i = 1; i < n; ++i){
        g[n+i][0] = A[i];
        g[n+i][1] = B[i];
    }
    dfs(2*n-1,2*n-1);
    for(int j = 1; j <= Q; ++j){
        if(K[j]==1){
            O[j] = n-1;
            continue;
        }
        vector<int> u = U[j];
        int k = K[j];
        sort(u.begin()+1, u.end(), [&](int x, int y){
            return d[x] > d[y];
        });
        int b = lca(u[1],u[2]);
        O[j] = 0;
        if(k > 10) continue;
        for(int i = 1; i <= k; ++i){
            for(int j = i+1; j <= k; ++j){
                int z = lca(u[i],u[j]);
                int t = lca(b,z);
                if(t != b && t != z) O[j] = -1;
                else if(d[z] > d[b]) b = z;
            }
        }
        if(O[j] == -1) O[j] = 0;
        else{
            O[j] = c[b];
            for(int i = 1; i <= k; ++i) if(lca(b,u[i])==b) O[j]--;
        }
    }
}