#include <bits/stdc++.h>

using namespace std;

#define MAXN 200001
#define MAXM 20

int n;
vector<int> adj[2*MAXN];
int parent[MAXM][2*MAXN];
int brlistova[2*MAXN];
int dist[2*MAXN];

void dfs(int node,int pret,int depth)
{
    parent[0][node]=pret;dist[node]=depth;if (adj[node].size()==1) brlistova[node]=1;
    for (int sled:adj[node])
    {
        if (sled!=pret) {dfs(sled,node,depth+1);brlistova[node]+=brlistova[sled];}
    }
}

int jump(int node,int k)
{
    for (int bit=MAXM-1;bit>=0;bit--)
    {
        if (k<(1<<bit)) continue;
        node=parent[bit][node];k-=(1<<bit);
    }
    return node;
}

int lca(int node1,int node2)
{
    if (dist[node1]>dist[node2]) swap(node1,node2);
    node1=jump(node1,dist[node1]-dist[node2]);
    if (node1==node2) return node1;
    for (int bit=MAXM-1;bit>=0;bit--)
    {
        if (parent[bit][node1]!=parent[bit][node2]) {node1=parent[bit][node1];node2=parent[bit][node2];}
    }
    return parent[0][node1];
}

void Nalbandian(int N, int Q, int* A, int* B, int* K, std::vector<int>* U, int* O)
{
    for (int i=1;i<N;i++)
    {
        adj[i+N].push_back(A[i]);adj[i+N].push_back(B[i]);
        adj[A[i]].push_back(i+N);adj[B[i]].push_back(i+N);
    }
    dfs(2*N-1,0,0);
    for (int j=1;j<MAXM;j++)
    {
        for (int i=1;i<=2*N-1;i++) parent[j][i]=parent[j-1][parent[j-1][i]];
    }
    for (int i=1;i<=Q;i++)
    {
        if (K[i]==1) {O[i]=N-1;continue;}
        else if (K[i]==2) {O[i]=brlistova[lca(U[i][1],U[i][2])]-2;continue;}
        int node1=U[i][1],node2=U[i][2],node3=U[i][3];int node=lca(node1,node2);node=lca(node,node3);
        int lca1=lca(node1,node2),lca2=lca(node2,node3),lca3=lca(node3,node1);
        if (brlistova[lca1]==2 or brlistova[lca2]==2 or brlistova[lca3]==2) {O[i]=0;continue;}
        else {O[i]=brlistova[node]-3;continue;}
    }
};