/// Dodaj da nema 3 kolinearne i N>=4
#include<bits/stdc++.h>
#define ll long long
using namespace std;
const int maxn=2e5+5;
int N;
void greska(string a){
   cerr<<a<<endl;
   exit(-1);
}
int min3(int a,int b,int c){
   return min(a,min(b,c));
}
int max3(int a,int b,int c){
   return max(a,max(b,c));
}
struct tacka{
   ll x,y;
   const bool operator == (const tacka &a) const{
      return x==a.x and y==a.y;
   }
}niz[maxn];
bool cmp(tacka a,tacka b){ /// Sortira tacke po x i y osi
   if(a.x<b.x)
      return true;
   if(a.x>b.x)
      return false;
   return a.y<b.y;
}
ll orijent(tacka p1,tacka p2,tacka a){ /// Nalazi orijentaciju tacke a u odnosu na pravu p1 - p2
   tacka v1;
   v1.x=p2.x-p1.x;
   v1.y=p2.y-p1.y;

   tacka v2;
   v2.x=a.x-p1.x;
   v2.y=a.y-p1.y;

   ll ort=v1.x*v2.y-v1.y*v2.x;
   if(ort==0)
      greska("NASAO 3 KOLINEARNE!");
   if(ort<0)
      return -1;
   return 1;
}
ll povrsina(tacka x,tacka y,tacka z){ /// Povrsina trougla
   tacka v1;
   tacka v2;
   v1.x=y.x-x.x;
   v1.y=y.y-x.y;
   v2.x=z.x-x.x;
   v2.y=z.y-x.y;
   return abs(v1.x*v2.y-v2.x*v1.y)/2;
}
ll povrsina(vector<tacka> V){ /// Povrsina konveksnog monougla V
   if(V.size()<=2)
      return 0;
   ll ans=0;
   for(int i=1;i+1<V.size();i++)
      ans+=povrsina(V[0],V[i],V[i+1]);
   return ans;
}
tacka glavna;
bool cmp2(tacka a,tacka b){ /// Sortira tacke po orijentaciji u odnosu na glavnu tacku
   return (a.y-glavna.y)*(b.x-glavna.x)<=(b.y-glavna.y)*(a.x-glavna.x);
}
vector<tacka> makehull(vector<tacka> V){ /// Pravi konveksni omotac od V tacaka. Vazno je da je V vec sortiran po x i y
   if(V.size()<=2)
      return V;
   vector<tacka> H; /// H ce biti konveksni omotac, sortiran redom tako da izmedju 2 susedna broja postoji duz

   H.push_back(V[0]); /// Najlevlja tacka je sigurno u omotacu
   glavna=V[0];
   sort(V.begin()+1,V.end(),cmp2); /// Sortira ostale tacke po orijentaciji

   for(int i=1;i<V.size();i++){ /// Ubacuje tacke redom

      while(H.size()>=2){ /// Sve dok je monougao nekonveksan, izbaci poslednju tacku
         tacka koja=H.back();
         H.pop_back();

         if(orijent(H.back(),koja,V[i])==1){ /// Monougao je konveksan, kraj procesa
            H.push_back(koja);
            break;
         }
      }

      H.push_back(V[i]);
   }

   return H;
}
bool pripada(tacka a,tacka b,tacka c, tacka x){ /// Da li tacka x pripada trouglu od tacaka a, b, c
   if(x==a or x==b or x==c) /// Ovo moramo da proverimo da ne bi dao gresku za 3 kolinearne kada je jedna tacka ponovljena
      return true;

   int o1,o2,o3;
   o1=orijent(a,b,x);
   o2=orijent(b,c,x);
   o3=orijent(c,a,x);

   return o1==o2 and o2==o3;
}
int nadji(int x){ /// Binarno trazi najveci indeks tacke kojoj je x koordinata <=x
   int dg=1,gg=N,ret=0,sred;
   while(dg<=gg){
      sred=(dg+gg)/2;
      if(niz[sred].x<=x){
         ret=sred;
         dg=sred+1;
      }
      else
         gg=sred-1;
   }
   return ret;
}
int main(){
   /// Unos podataka
   cin>>N;
   for(int i=1;i<=N;i++)
      cin>>niz[i].x>>niz[i].y;
   /// Sortiranje po x osi
   sort(niz+1,niz+1+N,cmp);

   /// Hull vektor koji sadrzi konveksni omotac. Vektor A je samo privremeni posto funckija makehull prima vektor kao ulaz.
   vector<tacka> A,hull;
   for(int i=1;i<=N;i++)
      A.push_back(niz[i]);
   hull=makehull(A);
   /// Vektor A se ne koristi nakon ove linije

   ll orgp=povrsina(hull); /// Povrsina originalnog omotaca
   ll res=0; /// Najvece smanjenje povrsine moguce izbacivanjem jedne tacke

   /// Da bi lakse procesirali 'trouglove' omotaca, ponavljamo prve dve tacke. Garantuje se da omotac ima bar 3 tacke iz uslova N>=4
   hull.push_back(hull[0]);
   hull.push_back(hull[1]);

   for(int i=1;i+1<hull.size();i++){ ///Iteriramo kroz tacke na omotacu
      /// Smanjenje povrsine kada se skloni tacka i. To je jednako povrsini trougla - povrsina konveksnog omotaca tacaka ispod njega (ukljucujuci druga dva temena). Inicijalizujemo ga na povrsinu trougla, pa cemo kasnije oduzeti povrsinu konveksnog omotaca.
      ll smanjenje_povrsine=povrsina(hull[i-1],hull[i],hull[i+1]);

      /// Najmanja i najveca vrednost x u trouglu. Ovo nam treba kako bi nasli tacke koje uopste vredi proveravati da li su u trouglu. Ako bi proveravali sve tacke to bi bilo O(N * velicina_omotaca) i presporo. Na ovaj nacin svaku tacku proverimo najvise 4 puta.
      int x1=min3(hull[i-1].x,hull[i].x,hull[i+1].x);
      int x2=max3(hull[i-1].x,hull[i].x,hull[i+1].x);

      /// Nalazimo pocetak i kraja intervala tacaka koje treba da proverimo da li su u trouglu
      int poc=nadji(x1-1)+1;
      int kraj=nadji(x2);


      vector<tacka> u_trouglu; /// Vektor koji sadrzi sve tacke koje pripadaju trouglu koji je sklonjen
      for(int j=poc;j<=kraj;j++){
         if(niz[j]==hull[i]) /// Preskacemo tacku koju smo sklonili
            continue;
         if(!pripada(hull[i-1],hull[i],hull[i+1],niz[j]))
            continue;
         u_trouglu.push_back(niz[j]);
      }

      /// Ako ima neka tacka u trouglu sem druga dva temena, oduzimamo povrsinu
      if(u_trouglu.size()>2)
         smanjenje_povrsine-=povrsina(makehull(u_trouglu));

      res=max(res,smanjenje_povrsine);
   }
   cout<<orgp-res<<"\n";
   return 0;
}
