#include <bits/stdc++.h>

using namespace std;

const int MAX = int(2e5);

const int NODES = MAX * 31;

int root[MAX], ch[NODES + 5][2], tsz;

int ids[NODES + 5], stk_beg, stk_end;

vector<int> vals[MAX];

int newNode() {
  int ret = ids[stk_beg];
  stk_beg = (stk_beg + 1) % NODES;
  return ret;
}

void delNode(int id) {
  stk_end = (stk_end + 1) % NODES;
  ids[stk_end] = id;
}

void InsertXor(int& node, int bit, int val) {
  if (!node) {
    node = newNode();
  }
  if (bit < 0) {
    return;
  }
  int my = (val >> bit & 1);
  InsertXor(ch[node][my], bit - 1, val);
}

int QueryMax(int node, int bit, int val) {
  if (bit < 0) {
    return 0;
  }
  int my = (val >> bit & 1);
  if (ch[node][my ^ 1] > 0) {
    return QueryMax(ch[node][my ^ 1], bit - 1, val) + (1 << bit);
  } else {
    return QueryMax(ch[node][my], bit - 1, val);
  }
}

void Clear(int& node) {
  if (ch[node][0] > 0) {
    Clear(ch[node][0]);
  }
  if (ch[node][1] > 0) {
    Clear(ch[node][1]);
  }
  delNode(node);
  node = 0;
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(0);
  {
    stk_beg = 0;
    stk_end = NODES - 1;
    for (int i = 0; i < NODES; i++) {
      ids[i] = i + 1;
    }
  }
  int n;
  cin >> n;
  vector<int> a(n);
  for (int i = 0; i < n; i++) {
    cin >> a[i];
  }
  vector<int> b(n);
  for (int i = 0; i < n; i++) {
    cin >> b[i];
  }
  vector<int> pref(n);
  for (int i = 0; i < n; i++) {
    pref[i] = (i == 0 ? 0 : pref[i - 1]) ^ a[i];
  }
  vector<pair<int, int>> segs;
  int64_t res = 0;
  for (int i = 0; i < n; i++) {
    res = max(res, a[i] * 1LL * b[i]);
    for (auto& p : segs) {
      p.first &= b[i];
    }
    {
      // Update results
      for (auto& p : segs) {
        res = max(res, int64_t(QueryMax(root[p.second], 31, pref[i])) * int64_t(p.first));
      }
    }
    segs.emplace_back(b[i], i);
    InsertXor(root[i], 31, i == 0 ? 0 : pref[i - 1]);
    vals[i].push_back(i == 0 ? 0 : pref[i - 1]);
    {
      // Merge equal segments
      vector<pair<int, int>> new_segs;
      for (int x = 0; x < int(segs.size()); x++) {
        int y = x;
        while (y + 1 < int(segs.size()) && segs[y + 1].first == segs[x].first) {
          y += 1;
        }
        int pos = segs[x].second;
        for (int t = x + 1; t <= y; t++) {
          Clear(root[segs[t].second]);
          for (int v : vals[segs[t].second]) {
            InsertXor(root[pos], 31, v);
            vals[pos].push_back(v);
          }
        }
        new_segs.push_back(segs[x]);
        x = y;
      }
      swap(segs, new_segs);
    }
  } 
  cout << res << '\n';
  return 0;
}