#include <cstdint>
#include <cstdio>
#include <iostream>
#include <map>
#include <set>
#include <string>
#include <vector>

enum {
  Free,
  Wall,
  Fire,
  Steva
};

using Map_t = std::vector<std::vector<uint8_t>>;

typedef struct {
  int32_t x;
  int32_t y;
} Vec2D;

// Also includes diagonals which weren't used
// Vec2D TRANSLATION_VECS[] = {
//   {1, 0},
//   {1, 1},
//   {0, 1},
//   {-1, 1},
//   {-1, 0},
//   {-1, -1},
//   {0, -1},
//   {1, -1},
// };
// uint8_t TRANSLATION_VECS_LEN = 8; 

Vec2D TRANSLATION_VECS[] = {
  {-1, 0},
  {1, 0},
  {0, 1},
  {0, -1},
};
uint8_t TRANSLATION_VECS_LEN = 4; 


std::vector<std::string> input_map(uint32_t h, uint32_t w) {
  auto map = std::vector<std::string>(h);
  for (int line = 0; line < h; line++) {
    std::getline(std::cin, map[line], '\n');
  }
  return map;
}

std::vector<uint8_t> parse_ln(std::string& ln) {
  auto out = std::vector<uint8_t>(ln.size());
  for (int i = 0; i < ln.size(); i++) {
    switch (ln[i]) {
      case '*':
        out[i] = Wall;
        break;
      case 'X':
        out[i] = Fire;
        break;
      case 'S':
        out[i] = Steva;
        break;
      default:
        out[i] = Free;
        break;
    };
  }
  return out; 
}

// Returns if cell has been changed
bool do_fire(Map_t& map, uint32_t x, uint32_t y) {
  if (map[y][x] == Free) {
    map[y][x] = Fire;
    return 1;
  }
  return 0;
}
bool do_steva(Map_t& map, uint32_t x, uint32_t y) {
  if (map[y][x] == Free) {
    map[y][x] = Steva;
    return 1;
  }
  return 0;
}

bool is_fire(uint8_t cellVal)  { return cellVal == Fire; }
bool is_steva(uint8_t cellVal) { return cellVal == Steva; }

// Returns how many cells were changed
uint32_t for_each_neighbor(Map_t& map, bool (*useThisCell)(uint8_t cellVal), bool (*exec)(Map_t& map, uint32_t x, uint32_t y)) {
  std::map<uint32_t, std::set<uint32_t>> used_cells = {};
  uint32_t changes = 0;
  for (int row = 0; row < map.size(); row++) {
    for (int column = 0; column < map[row].size(); column++) {
      if(used_cells[row].count(column) ||
        !useThisCell(map[row][column])) { continue; }
      for (uint8_t tvi = 0; tvi < TRANSLATION_VECS_LEN; tvi++) {
        uint32_t tryy = row + TRANSLATION_VECS[tvi].y;
        uint32_t tryx = column + TRANSLATION_VECS[tvi].x;
        if (tryy >= 0 && tryy < map.size() &&
          tryx >= 0 && tryx < map[tryy].size()) {
          if (exec(map, tryx, tryy)) {
            used_cells[tryy].insert(tryx);
            changes++;
          }
        }
      }
    }
  }
  return changes;
}

int main() {
  uint32_t h, w;
  std::cin >> h >> w;
  std::cin.ignore();
  auto mapIn = input_map(h, w);
  // Parse map
  auto map = std::vector<std::vector<uint8_t>>(mapIn.size(), std::vector<uint8_t>(mapIn[0].size()));
  for (int line = 0; line < mapIn.size(); line++) {
    map[line] = parse_ln(mapIn[line]);
  }

  uint32_t steva_changed_cells_sum = 0;
  while (1) {
    uint32_t fire_changed_cells = for_each_neighbor(map, is_fire, do_fire);
    uint32_t steva_changed_cells = for_each_neighbor(map, is_steva, do_steva);
    if (fire_changed_cells == 0 && steva_changed_cells == 0) { break; }
    steva_changed_cells_sum += steva_changed_cells;
  }
  std::cout << "steva_changed_cells: " << steva_changed_cells_sum+1 << '\n';
  return 0;
}