from collections import deque


def in_bounds(x, y, n, m):
    return 0 <= x < n and 0 <= y < m


def bfs_fire(n, m, grid, fire_start):
    fire_time = [[-1] * m for _ in range(n)] 
    q = deque(fire_start)  
    for x, y in fire_start:
        fire_time[x][y] = 0
    directions = [(-1, 0), (1, 0), (0, -1), (0, 1)]  

    while q:
        x, y = q.popleft()
        for dx, dy in directions:
            nx, ny = x + dx, y + dy
            if in_bounds(nx, ny, n, m) and grid[nx][ny] == '.' and fire_time[nx][ny] == -1:
                fire_time[nx][ny] = fire_time[x][y] + 1
                q.append((nx, ny))
    return fire_time


def bfs_steve(n, m, grid, start_x, start_y, fire_time):
    steve_time = [[-1] * m for _ in range(n)]  
    q = deque([(start_x, start_y)])  
    steve_time[start_x][start_y] = 0  
    directions = [(-1, 0), (1, 0), (0, -1), (0, 1)]  

    while q:
        x, y = q.popleft()
        for dx, dy in directions:
            nx, ny = x + dx, y + dy
            if in_bounds(nx, ny, n, m) and grid[nx][ny] == '.' and steve_time[nx][ny] == -1:
                steve_time[nx][ny] = steve_time[x][y] + 1
                q.append((nx, ny))
    return steve_time


def solve(n, m, grid):
    fire_start = []
    steve_start = (-1, -1)

    
    for i in range(n):
        for j in range(m):
            if grid[i][j] == 'S':
                steve_start = (i, j)
            elif grid[i][j] == 'X':
                fire_start.append((i, j))

    
    if not fire_start:
        print(n * m)
        return
    
    
    fire_time = bfs_fire(n, m, grid, fire_start)

    
    steve_time = bfs_steve(n, m, grid, steve_start[0], steve_start[1], fire_time)

    
    count = 0
    for i in range(n):
        for j in range(m):
            
            if grid[i][j] == '.' and steve_time[i][j] != -1 and (fire_time[i][j] == -1 or steve_time[i][j] < fire_time[i][j]):
                count += 1

    print(count+1)


n, m = map(int, input().split())
grid = [input().strip() for _ in range(n)]


solve(n, m, grid)