using System;
using System.Collections.Generic;
using System.Linq;

namespace Petlja
{
    internal class Program
    {
        private static void Main()
        {
            string[] input1 = (Console.ReadLine() ?? "0 0").Split(' ');
            int n = int.Parse(input1[0]);
            int q = int.Parse(input1[1]);
            List<(long d, long p)> days = [];
            List<long> questions = [];

            for (int i = 0; i < n; i++)
            {
                string[] inputI = (Console.ReadLine() ?? "0 0").Split(' ');
                days.Add((long.Parse(inputI[0]), long.Parse(inputI[1])));
            }

            for (int i = 0; i < q; i++)
                questions.Add(long.Parse(Console.ReadLine() ?? "0"));

            foreach (long finalDay in questions)
                SolveForQ(finalDay, days);
        }

        private static void SolveForQ(long finalDay, List<(long d, long p)> days)
        {
            long currentAvailableCount = 0;
            long currentEatenCount = 0;
            long currentDay = 0;

            foreach ((long d, long p) in (List<(long d, long p)>)[.. days.Where(x => x.d < finalDay), (finalDay + 1, 0L)])
            {
                if (currentAvailableCount > d - currentDay)
                {
                    currentAvailableCount -= d - currentDay;
                    currentEatenCount += d - currentDay;
                }
                else
                {
                    currentEatenCount += currentAvailableCount;
                    currentAvailableCount = 0;
                }

                currentAvailableCount += p;
                currentDay = d;
            }

            Console.WriteLine(currentEatenCount);
        }
    }
}