using System;
using System.Collections.Generic;
using Vector2 = (int x, int y);

namespace Petlja
{
    internal class Program
    {
        private static void Main()
        {
            string[] input1 = (Console.ReadLine() ?? "0 0").Split(' ');
            int n = int.Parse(input1[0]);
            int m = int.Parse(input1[1]);
            char[,] tiles = new char[n, m];

            int[,] steveMatrix = new int[n, m];
            Queue<(Vector2, int)> steveQueue = new();

            int[,] fireMatrix = new int[n, m];
            Queue<(Vector2, int)> fireQueue = new();

            for (int i = 0; i < n; i++)
            {
                string inputI = Console.ReadLine() ?? "";
                for (int j = 0; j < m; j++)
                {
                    tiles[i, j] = inputI[j];
                    if (inputI[j] == 'X')
                        fireQueue.Enqueue(((i, j), 1));
                    else if (inputI[j] == 'S')
                        steveQueue.Enqueue(((i, j), 1));
                }
            }

            while (steveQueue.TryDequeue(out ((int x, int y) position, int time) current))
            {
                steveMatrix[current.position.x, current.position.y] = current.time;
                tiles[current.position.x, current.position.y] = 'S';

                if (current.position.x > 0 && tiles[current.position.x - 1, current.position.y] == '.')
                    steveQueue.Enqueue(((current.position.x - 1, current.position.y), current.time + 1));

                if (current.position.x < n - 1 && tiles[current.position.x + 1, current.position.y] == '.')
                    steveQueue.Enqueue(((current.position.x + 1, current.position.y), current.time + 1));

                if (current.position.y > 0 && tiles[current.position.x, current.position.y - 1] == '.')
                    steveQueue.Enqueue(((current.position.x, current.position.y - 1), current.time + 1));

                if (current.position.y < m - 1 && tiles[current.position.x, current.position.y + 1] == '.')
                    steveQueue.Enqueue(((current.position.x, current.position.y + 1), current.time + 1));
            }

            while (fireQueue.TryDequeue(out ((int x, int y) position, int time) current))
            {
                fireMatrix[current.position.x, current.position.y] = current.time;
                tiles[current.position.x, current.position.y] = 'X';

                if (current.position.x > 0 && tiles[current.position.x - 1, current.position.y] == 'S')
                    fireQueue.Enqueue(((current.position.x - 1, current.position.y), current.time + 1));

                if (current.position.x < n - 1 && tiles[current.position.x + 1, current.position.y] == 'S')
                    fireQueue.Enqueue(((current.position.x + 1, current.position.y), current.time + 1));

                if (current.position.y > 0 && tiles[current.position.x, current.position.y - 1] == 'S')
                    fireQueue.Enqueue(((current.position.x, current.position.y - 1), current.time + 1));

                if (current.position.y < m - 1 && tiles[current.position.x, current.position.y + 1] == 'S')
                    fireQueue.Enqueue(((current.position.x, current.position.y + 1), current.time + 1));
            }

            int possibleEscapes = 0;
            for (int i = 0; i < n; i++)
            {
                for (int j = 0; j < m; j++)
                {
                    if ((steveMatrix[i, j] > 0 && fireMatrix[i, j] == 0) || (steveMatrix[i, j] > 0 && fireMatrix[i, j] > 0 && steveMatrix[i, j] < fireMatrix[i, j]))
                    {
                        possibleEscapes++;
                    }
                }
            }
            Console.WriteLine(possibleEscapes);
        }
    }
}