#include <bits/stdc++.h>

using namespace std;

const int dx[4] = { -1, 1, 0, 0 };
const int dy[4] = { 0, 0, -1, 1 };

int main()
{

    ios::sync_with_stdio(false);
    cin.tie(NULL);

    int N, M;
    cin >> N >> M;

    vector<string> lavirint(N);
    pair<int, int> steva_pozicija;
    vector<vector<int>> vremeVatre(N, vector<int>(M, INT_MAX));
    queue<pair<int, int>> redVatre;

    for (int i = 0; i < N; ++i)
    {
        cin >> lavirint[i];
        for (int j = 0; j < M; ++j)
        {
            if (lavirint[i][j] == 'S')
            {
                steva_pozicija = { i, j };
            }
            else if (lavirint[i][j] == 'X')
            {
                vremeVatre[i][j] = 0;
                redVatre.push({ i, j });
            }
        }
    }
    while (!redVatre.empty())
    {
        auto [x, y] = redVatre.front();
        redVatre.pop();

        for (int i = 0; i < 4; ++i)
        {
            int nx = x + dx[i];
            int ny = y + dy[i];

            if (nx >= 0 && nx < N && ny >= 0 && ny < M)
            {
                if (lavirint[nx][ny] != '*' && vremeVatre[nx][ny] == INT_MAX)
                {
                    vremeVatre[nx][ny] = vremeVatre[x][y] + 1;
                    redVatre.push({ nx, ny });
                }
            }
        }
    }
    vector<vector<int>> vremeSteve(N, vector<int>(M, INT_MAX));
    queue<pair<int, int>> redSteve;

    if (vremeVatre[steva_pozicija.first][steva_pozicija.second] > 0)
    {
        vremeSteve[steva_pozicija.first][steva_pozicija.second] = 0;
        redSteve.push(steva_pozicija);
    }
    while (!redSteve.empty())
    {
        auto [x, y] = redSteve.front();
        redSteve.pop();
        int trenutno_vreme = vremeSteve[x][y];

        for (int i = 0; i < 4; ++i)
        {
            int nx = x + dx[i];
            int ny = y + dy[i];
            int sledece_vreme = trenutno_vreme + 1;
            if (nx >= 0 && nx < N && ny >= 0 && ny < M)
            {
                if (lavirint[nx][ny] != '*' && vremeSteve[nx][ny] == INT_MAX)
                {
                    if (vremeVatre[nx][ny] > sledece_vreme)
                    {
                        vremeSteve[nx][ny] = sledece_vreme;
                        redSteve.push({ nx, ny });
                    }
                }
            }
        }
    }
    int broj_polja = 0;

    for (int i = 0; i < N; ++i)
    {
        for (int j = 0; j < M; ++j)
        {
            if (lavirint[i][j] != '*' && lavirint[i][j] != 'X')
            {
                if (vremeSteve[i][j] < vremeVatre[i][j])
                {
                    broj_polja++;
                }
            }
        }
    }

    cout << broj_polja << endl;
    return 0;
}