from collections import deque

n, m = map(int, input().split())
matrica = [list(input().strip()) for _ in range(n)]

kretanje = [(-1, 0), (1, 0), (0, -1), (0, 1)]

def add_to_queue(queue, game_matrix, direkciona_matrica, n, m):
    while queue:
        x, y = queue.popleft()
        for kx, ky in kretanje:
            nx, ny = x + kx, y + ky
            if 0 <= nx < n and 0 <= ny < m and game_matrix[nx][ny] == '.' and direkciona_matrica[nx][ny] == float('inf'):
                direkciona_matrica[nx][ny] = direkciona_matrica[x][y] + 1
                queue.append((nx, ny))


vatra_matrica = [[float('inf')] * m for _ in range(n)]
steva_matrica = [[float('inf')] * m for _ in range(n)]


vatra_queue = deque()
steva_queue = deque()


steva_x, steva_y = -1, -1

for i in range(n):
    for j in range(m):
        if matrica[i][j] == 'X': 
            vatra_queue.append((i, j))
            vatra_matrica[i][j] = 0
        elif matrica[i][j] == 'S':
            steva_x, steva_y = i, j
            steva_matrica[i][j] = 0
        elif matrica[i][j] == '.':
            vatra_matrica[i][j] = float('inf')
            steva_matrica[i][j] = float('inf')


add_to_queue(vatra_queue, matrica, vatra_matrica, n, m)

steva_queue.append((steva_x, steva_y))
add_to_queue(steva_queue, matrica, steva_matrica, n, m)


res = 1
for i in range(n):
    for j in range(m):
        if matrica[i][j] == '.' and steva_matrica[i][j] < vatra_matrica[i][j]:
            res += 1

print(res)