#include <bits/stdc++.h>
using namespace std;

const int dr[] = {0, 0, 1, -1}; 
const int dc[] = {1, -1, 0, 0};

struct Point {
    int r, c;
};

bool unutra(int r, int c, int N, int M) {
    return r >= 0 && r < N && c >= 0 && c < M;
}

int main() {
    int N, M;
    cin >> N >> M;

    vector<string> grid(N);
    queue<Point> vatra, steva;
    vector<vector<int>> vatravreme(N, vector<int>(M, -1));
    vector<vector<bool>> pogledano(N, vector<bool>(M, false));

    Point start;
    for (int i = 0; i < N; ++i) {
        cin >> grid[i];
        for (int j = 0; j < M; ++j) {
            if (grid[i][j] == 'x') {
                vatra.push({i, j});
                vatravreme[i][j] = 0; 
            } else if (grid[i][j] == 'S') {
                start = {i, j};
            }
        }
    }
    while (!vatra.empty()) {
        Point tr = vatra.front();
        vatra.pop();

        for (int d = 0; d < 4; ++d) {
            int nr = tr.r + dr[d];
            int nc = tr.c + dc[d];

            if (unutra(nr, nc, N, M) && grid[nr][nc] == '.' && vatravreme[nr][nc] == -1) {
                vatravreme[nr][nc] = vatravreme[tr.r][tr.c] + 1;
                vatra.push({nr, nc});
            }
        }
    }
    steva.push(start);
    pogledano[start.r][start.c] = true;

    int br = 0;

    while (!steva.empty()) {
        Point tr = steva.front();
        steva.pop();

        for (int d = 0; d < 4; ++d) {
            int nr = tr.r + dr[d];
            int nc = tr.c + dc[d];
            if (!unutra(nr, nc, N, M)) {
                br++;
                continue;
            }
            if (grid[nr][nc] == '.' && !pogledano[nr][nc] && 
                (vatravreme[nr][nc] == -1 || vatravreme[nr][nc] > vatravreme[tr.r][tr.c] + 1)) {
                pogledano[nr][nc] = true;
                steva.push({nr, nc});
            }
        }
    }
    cout << br << endl;
    return 0;
}