using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace vezba
{
    class Program
    {
        static void bfs(char[,] matrica, Queue<(int, int, char)> red)
        {
            int n = matrica.GetLength(0);
            int m = matrica.GetLength(1);

            while (red.Count > 0)
            {
                var (v, k, polje) = red.Dequeue();
                int[] dx = { -1, 0, 1, 0 };
                int[] dy = { 0, 1, 0, -1 };
                for (int i = 0; i < 4; i++)
                {
                    int xx = v + dx[i], yy = k + dy[i];
                    if (xx >= 0 && xx < n && yy >= 0 && yy < m && matrica[xx, yy] == '.')
                    {
                        if (polje == 'X')
                        {
                            matrica[xx, yy] = 'X'; 
                            red.Enqueue((xx, yy, 'X'));
                        }
                        else if (polje == 'S')
                        {
                            matrica[xx, yy] = 'S';
                            red.Enqueue((xx, yy, 'S'));
                        }
                    }
                }
            }
        }
        
        static void Main(string[] args)
        {
            string[] dim = Console.ReadLine().Split();
            int n = int.Parse(dim[0]);
            int m = int.Parse(dim[1]);
            char[,] matrica = new char[n, m];
            Queue<(int, int, char)> red = new Queue<(int, int, char)>();
            (int, int) steva = (-1, -1);
            for (int i = 0; i < n; i++)
            {
                string s = Console.ReadLine();
                for (int j = 0; j < m; j++)
                {
                    matrica[i, j] = s[j];
                    if (matrica[i, j] == 'X')
                    {
                        red.Enqueue((i, j, 'X'));
                    }
                    else if (matrica[i, j] == 'S')
                    {
                        steva = (i, j);
                    }
                }
            }
            red.Enqueue((steva.Item1, steva.Item2, 'S'));
            bfs(matrica, red);
            int br = 0;
            for (int i = 0; i < n; i++)
            {
                for (int j = 0; j < m; j++)
                {
                    if (matrica[i, j] == 'S') br++;
                }
            }
            Console.WriteLine(br);
            Console.ReadLine();
        }
    }
}