#include <stdio.h>
#include <string.h>
#define MAXN 1000
#define MAXM 1000

char lavirint[MAXN][MAXM];
int udaljenostSteva[MAXN][MAXM], udaljenostVatra[MAXN][MAXM];
int n, m, stevaX, stevaY;
int dx[] = {-1, 1, 0, 0}, dy[] = {0, 0, -1, 1};
typedef struct { int x, y; } Tacka;
Tacka red[MAXN * MAXM];
int pocetak, kraj;

void bfs(int udaljenost[MAXN][MAXM]) {
    while (pocetak < kraj) {
        Tacka t = red[pocetak++];
        for (int i = 0; i < 4; i++) {
            int nx = t.x + dx[i], ny = t.y + dy[i];
            if (nx >= 0 && nx < n && ny >= 0 && ny < m && lavirint[nx][ny] == '.' && udaljenost[nx][ny] == -1) {
                udaljenost[nx][ny] = udaljenost[t.x][t.y] + 1;
                red[kraj++] = (Tacka){nx, ny};
            }
        }
    }
}

int main() {
    scanf("%d %d", &n, &m);
    for (int i = 0; i < n; i++) {
        scanf("%s", lavirint[i]);
        for (int j = 0; j < m; j++) {
            if (lavirint[i][j] == 'S') {
                stevaX = i;
                stevaY = j;
            } else if (lavirint[i][j] == 'X') {
                udaljenostVatra[i][j] = 0;
                red[kraj++] = (Tacka){i, j};
            }
        }
    }

    memset(udaljenostVatra, -1, sizeof(udaljenostVatra));
    for (int i = 0; i < kraj; i++) {
        Tacka t = red[i];
        udaljenostVatra[t.x][t.y] = 0;
    }
    pocetak = 0;
    bfs(udaljenostVatra);

    memset(udaljenostSteva, -1, sizeof(udaljenostSteva));
    pocetak = 0;
    kraj = 0;
    udaljenostSteva[stevaX][stevaY] = 0;
    red[kraj++] = (Tacka){stevaX, stevaY};
    bfs(udaljenostSteva);

    int brojPolja = 0;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            if (udaljenostSteva[i][j] != -1 && 
               (udaljenostVatra[i][j] == -1 || udaljenostSteva[i][j] < udaljenostVatra[i][j])) {
                brojPolja++;
            }
        }
    }
    printf("%d\n", brojPolja);

    return 0;
}