using System;

namespace Takprog02
{
    internal class Program02
    {
        static void Main(string[] args)
        {
            int N, Q;
            // Unosenje broja kupovina i broja pitanja
            var prviRed = Console.ReadLine();
            var nizStr = prviRed.Split(' ');
            if (nizStr.Length != 2)
            {
                Console.WriteLine("Pogresan unos. Ocekuju se dva broja");
                return;
            }
            var prviStr = nizStr[0];
            var drugiStr = nizStr[1];
            if (!int.TryParse(prviStr, out N))
            {
                Console.WriteLine("Pogresan unos. Ocekuju se dva broja");
                return;
            }
            if (!int.TryParse(drugiStr, out Q))
            {
                Console.WriteLine("Pogresan unos. Ocekuju se dva broja");
                return;
            }

            // Niz sa danima za koje je bilo kupovine
            var D = new ulong[N];
            // Niz sa kolicinama kupljenih tog dana
            var K = new ulong[N];

            // Unosenje kupovine. Ocekujemo dva broja: DAN KOLICINA
            int i = 0;
            do
            {
                var red = Console.ReadLine();
                nizStr = red.Split(' ');
                if (nizStr.Length != 2)
                {
                    Console.WriteLine("Pogresan unos. Ocekuju se dva broja");
                    return;
                }
                prviStr = nizStr[0];
                drugiStr = nizStr[1];


                if (!ulong.TryParse(prviStr, out ulong d))
                {
                    Console.WriteLine("Pogresan unos. Ocekuju se dva broja");
                    return;
                }
                if (!ulong.TryParse(drugiStr, out ulong p))
                {
                    Console.WriteLine("Pogresan unos. Ocekuju se dva broja");
                    return;
                }
                D[i] = d;
                K[i] = p;

                i++;
            }
            while (i < N);

            // Niz sa danima za koje se pitamo koliko je pojedeno
            var J = new ulong[Q];
            // Unosenje dana pitanja ukupne potrosnje za taj dan. Ocekujemo jedan broj: DAN
            i = 0;
            do
            {
                var red = Console.ReadLine();
                if (!ulong.TryParse(red, out ulong pitanje))
                {
                    Console.WriteLine("Pogresan unos. Ocekuje se jedan broj");
                    return;
                }

                J[i] = pitanje;
                i++;
            }
            while (i < Q);

            // Racunanje

            // Racunamo za svaki dan iz pitanja

            for (int indexJ = 0; indexJ < Q; indexJ++)
            {
                // Uvek pocinjemo od nule
                ulong mag = 0;                  // Trenutno stanje broja plazmi koje su raspolozive cerki
                ulong pojedeno = 0;             // Koliko je pojedeno
                ulong danPoslednjeKupovine = 0; // Dan kada je poslednji put kupljeno pre dana za koji se pitamo / za koji racunamo

                // dan za koji racunamo koliko je pojedeno do tog dana
                var danPrestanka = J[indexJ];
                // Proveravamo svaku kupovinu i trazimo da li je bilo kupovine pre danPrestanka
                for (int indexD = 0; indexD < N; indexD++)
                {
                    var danKupovine = D[indexD];
                    // Ako je bilo kupovina pre dana za koji racunamo dodamo kupljenu kolicinu u magacin
                    if (danKupovine <= danPrestanka)
                    {
                        mag += K[indexD];
                        danPoslednjeKupovine = danKupovine;
                    }
                    // Da li ima jos dana kupovine pre dana za koji racunamo?
                    if (indexD < (N - 1))
                    {
                        // Ako ima racunamo koliko je bilo pojedeno izmedju tog dana i prethodnog dana kupovine
                        if (D[indexD + 1] <= danPrestanka)
                        {
                            danPoslednjeKupovine = D[indexD + 1];
                            // Ne moze se pojesti vise nego sto ima u magacinu
                            if ((danPoslednjeKupovine - danKupovine) > mag)
                            {
                                pojedeno += mag;
                                mag = 0;
                            }
                            else
                            {
                                pojedeno += (danPoslednjeKupovine - danKupovine);
                                mag = mag - (danPoslednjeKupovine - danKupovine);
                            }
                        }
                    }
                }
                // Ako je bilo kupovine koja se desila pre dana pitanja - izracunati koliko je pojedeno od tog dana do dana za koji se pitamo
                if (danPoslednjeKupovine > 0)
                {
                    // Ne moze se pojesti vise nego sto ima u magacinu
                    if ((danPrestanka - danPoslednjeKupovine) > mag)
                    {
                        pojedeno += mag;
                        mag = 0;
                    }
                    else
                    {
                        // Pojedeno je razlika broja dana + 1.
                        // primer za dane 2 i 4. pojedeno = 4-2+1 = 2+1 = 3. Jelo se 2, 3 i 4 dana - ukupno 3 dana.
                        pojedeno += (danPrestanka - danPoslednjeKupovine) + 1;
                        mag = mag - (danPrestanka - danPoslednjeKupovine) + 1;
                    }
                }
                Console.WriteLine(pojedeno);
            }
        }
    }
}