using System;
using System.Collections.Generic;

class Program
{
    static int[,] BFS(int[,] m, (int, int) t)
    {
        int[] dx = { -1, 1, 0, 0 };
        int[] dy = { 0, 0, -1, 1 };
        bool unutarGranica(int x, int y) => x >= 0 && x < m.GetLength(0) && y >= 0 && y < m.GetLength(1);
        Queue<(int, int)> queue = new Queue<(int, int)>();
        queue.Enqueue(t);
        m[t.Item1,t.Item2] = 0;
        while (queue.Count > 0)
        {
            var (x, y) = queue.Dequeue();
            for (int i = 0; i < 4; i++)
            {
                int nX = x + dx[i];
                int nY = y + dy[i];

                if (unutarGranica(nX, nY) && m[nX, nY] == int.MaxValue && m[nX, nY] != -1)
                {
                    m[nX, nY] = m[x, y] + 1;
                    queue.Enqueue((nX, nY));
                }
            }
        }
        return m;
    }
    static void Main()
    {
        string[] s = Console.ReadLine().Split();
        int n = int.Parse(s[0]), m = int.Parse(s[1]);
        int[,] M = new int[n, m];
        Queue<(int, int)> vatra = new Queue<(int, int)>();
        (int x, int y) steva=(0,0);
        for (int i = 0; i < n; i++)
        {
            string red = Console.ReadLine();
            for (int j = 0; j < m; j++) { 
                if (red[j] == '*') M[i, j] = -1;
                else M[i, j] = int.MaxValue;
                if (red[j] == 'X') vatra.Enqueue((i, j));
                else if (red[j] == 'S') steva = (i, j);
                }
        }
        if (vatra.Count > 0)
        {
            int[,] T = BFS(Kopija(M), vatra.Dequeue());
            while (vatra.Count > 0)
            {
                int[,] pomM = BFS(Kopija(M), vatra.Dequeue());
                for (int i = 0; i < n; i++)
                    for (int j = 0; j < m; j++)
                        T[i, j] = Math.Min(T[i, j], pomM[i, j]);
            }
            int br = 0;
            int[,] sM = BFS(Kopija(M), steva);
            for (int i = 0; i < n; i++)
                for (int j = 0; j < m; j++)
                    if (sM[i, j] < T[i, j]) br++;
            Console.WriteLine(br);
        }
        else
        {
            int br = 0;
            int[,] sM = BFS(M, steva);
            for (int i = 0; i < n; i++)
                for (int j = 0; j < m; j++)
                    if (sM[i, j] >= 0 && sM[i, j] < int.MaxValue) br++;
            Console.WriteLine(br);
        }
    }
    private static int[,] Kopija(int[,] m)
    {
        int[,] t = new int[m.GetLength(0), m.GetLength(1)];
        for (int i = 0; i < m.GetLength(0); i++)
            for (int j = 0; j < m.GetLength(1); j++)
                t[i, j] = m[i, j];
        return t;
    }
}