using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Xml.Linq;

namespace Pozar
{
    internal class Program
    {
        static int N;
        static int M;
        static char[,] P;

        static bool[] ReturnInboundSpaces(int X, int Y)
        {
            bool[] spaces = new bool[4];
            if(X - 1 < 0)
                spaces[0] = false;
            else
                spaces[0] = true;

            if (Y + 1 >= M)
                spaces[1] = false;
            else
                spaces[1] = true;

            if(X + 1 >= N)
                spaces[2] = false;
            else
                spaces[2] = true;

            if(Y - 1  < 0)
                spaces[3] = false;
            else
                spaces[3] = true;

            return spaces;
        }

        static char[] ReturnAvailableCharTypes(int X, int Y)
        {
            bool[] available = ReturnInboundSpaces(X, Y);
            char[] types = {'N','N','N','N'};
            if (available[0])
                types[0] = P[X-1, Y];
            if (available[1])
                types[1] = P[X, Y+1];
            if (available[2])
                types[2] = P[X+1, Y];
            if (available[3])
                types[3] = P[X, Y-1];

            return types;
        }

        static void FindAndMarkAllSteves()
        {
            for (int i = 0; i < N; i++)
            {
                for (int j = 0; j < M; j++)
                {
                    if (P[i, j] == 'S')
                    {
                        MarkMove(i, j, 'S');
                    }

                }
            }
        }

        static void FindAndMarkAllFires()
        {
            for (int i = 0; i < N; i++)
            {
                for (int j = 0; j < M; j++)
                {
                    if (P[i, j] == 'X')
                    {
                        MarkMove(i, j, 'X');
                    }

                }
            }
        }

        static void MarkMove(int X, int Y, char C)
        {
            char[] spaces = ReturnAvailableCharTypes(X, Y);
            for (int i = 0; i < spaces.Length; i++)
            {
                if (C == 'X')
                {
                    if (spaces[i] == '.' || spaces[i] == 'S' || spaces[i] == 's')
                        switch (i)
                        {
                            case 0:
                                P[X-1, Y] = 'x';
                                break;
                            case 1:
                                P[X, Y+1] = 'x';
                                break;
                            case 2:
                                P[X+1, Y] = 'x';
                                break;
                            case 3:
                                P[X, Y-1] = 'x';
                                break;
                        }
                }
                else
                {
                    if (spaces[i] == '.')
                        switch (i)
                        {
                            case 0:
                                P[X - 1, Y] = 's';
                                break;
                            case 1:
                                P[X, Y + 1] = 's';
                                break;
                            case 2:
                                P[X + 1, Y] = 's';
                                break;
                            case 3:
                                P[X, Y - 1] = 's';
                                break;
                        }
                }
            }
        }

        static void ExecuteMove()
        {
            for (int i = 0; i < N; i++)
            {
                for (int j = 0; j < M; j++)
                {
                    if (P[i, j] == 's')
                    {
                        P[i, j] = 'S';
                    }
                    if (P[i, j] == 'x')
                    {
                        P[i, j] = 'X';
                    }
                }
            }
        }

        static bool DocumentAllSpotsAndReturnEnd(List<int> X, List<int> Y)
        {
            bool modified = false;
            for (int i = 0; i < N; i++)
            {
                for (int j = 0; j < M; j++)
                {
                    bool contains = false;
                    if (P[i, j] == 'S')
                    {
                        for (int k = 0; k < X.Count; k++)
                        {
                            if (X[k] == i && Y[k] == j)
                                contains = true;
                        }
                        if(!contains)
                        {
                            X.Add(i); Y.Add(j);
                            modified = true;
                        }
                    }
                }
            }
            if (modified)
                return false;
            else
                return true;
        }

        static void Main(string[] args)
        {
            string[] dimensions = Console.ReadLine().Split();
            N = Convert.ToInt32(dimensions[0]);
            M = Convert.ToInt32(dimensions[1]);
            P = new char[N,M];
            for (int i = 0; i < N; i++)
            {
                string input = Console.ReadLine();
                StringBuilder brokendown = new StringBuilder(input);
                for (int j = 0; j < M; j++)
                {
                    P[i, j] = brokendown[j];
                }
            }

            List<int> XArray = new List<int>();
            List<int> YArray = new List<int>();
            bool AllSpotsFound = false;
            do
            {
                AllSpotsFound = DocumentAllSpotsAndReturnEnd(XArray, YArray);
                FindAndMarkAllSteves();
                FindAndMarkAllFires();
                ExecuteMove();
            }
            while (!AllSpotsFound);            

            Console.WriteLine(XArray.Count);
        }
    }
}