using System;
using System.Collections.Generic;

class Program
{
    static int[] direkcijaX = { -1, 1, 0, 0 };
    static int[] direkcijaY = { 0, 0, -1, 1 };
    static char[] simboli = { '.', '*', 'X', 'S' };

    public static void AddToQueue(Queue<int[]> red, char[,] matricaZaIgru, int[,] matricaZaKretanje, int n, int m)
    {
        while (red.Count > 0)
        {
            int[] trenutni = red.Dequeue();
            int x = trenutni[0], y = trenutni[1];
            for (int i = 0; i < 4; i++)
            {
                int nx = x + direkcijaX[i], ny = y + direkcijaY[i];
                if (nx >= 0 && ny >= 0 && nx < n && ny < m && matricaZaIgru[nx, ny] == simboli[0] && matricaZaKretanje[nx, ny] == int.MaxValue)
                {
                    matricaZaKretanje[nx, ny] = matricaZaKretanje[x, y] + 1;
                    red.Enqueue(new int[] { nx, ny });
                }
            }
        }
    }

    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int n = int.Parse(input[0]);
        int m = int.Parse(input[1]);
        var matrica = new char[n, m];
        var matricaZaVatru = new int[n, m];
        var matricaZaStevu = new int[n, m];
        var redZaVatru = new Queue<int[]>();
        var redZaStevu = new Queue<int[]>();
        int stevaX = -1, stevaY = -1;
        for (int i = 0; i < n; i++)
        {
            string linija = Console.ReadLine();
            for (int j = 0; j < m; j++)
            {
                matrica[i, j] = linija[j];
                if (matrica[i, j] == simboli[2]) 
                {
                    redZaVatru.Enqueue(new int[] { i, j });
                    matricaZaVatru[i, j] = 0;
                }
                else if (matrica[i, j] == simboli[3])
                {
                    stevaX = i;
                    stevaY = j;
                    matricaZaStevu[i, j] = 0;
                }
                else
                {
                    matricaZaVatru[i, j] = int.MaxValue;
                    matricaZaStevu[i, j] = int.MaxValue;
                }
            }
        }
        AddToQueue(redZaVatru, matrica, matricaZaVatru, n, m);
        redZaStevu.Enqueue(new int[] { stevaX, stevaY });
        matricaZaStevu[stevaX, stevaY] = 0;
        AddToQueue(redZaStevu, matrica, matricaZaStevu, n, m);
        int rezultat = 1;
        for (int i = 0; i < n; i++)
        {
            for (int j = 0; j < m; j++)
            {
                if (matrica[i, j] == '.' && matricaZaStevu[i, j] < matricaZaVatru[i, j])
                {
                    rezultat++;
                }
            }
        }
        Console.WriteLine(rezultat);
        Console.ReadKey();
    }
}