#include <iostream>

// limit l = 10^18
// 2^59 < l < 2^60
// 8 bajtova
typedef long long int ShLong;

struct DanBroj {
    ShLong day;
    ShLong keks;
};

void calculate(ShLong& keksCount, ShLong& daniJedenja, ShLong diff) {

    ShLong razlika = keksCount - diff;

    if(razlika > 0) {
        daniJedenja += diff;
        keksCount = razlika;
    }
    else {
        daniJedenja += keksCount;
        keksCount = 0;
    }
}

int main() {

    int n;
    int q;

    std::cin >> n >> q;

    DanBroj *dani = new DanBroj[n];

    for(int i = 0; i < n; i++) {
        std::cin >> dani[i].day >> dani[i].keks;
    }

    ShLong *pitanja = new ShLong[q];

    for(int i = 0; i < q; i++) {
        std::cin >> pitanja[i];
    }

    for(int current = 0; current < q; current++) {

        const ShLong targetDay = pitanja[current];
        ShLong keksCount = 0;
        ShLong daniJedenja = 0;
        ShLong currentDay = 1;

        for(int i = 0; i < n; i++) {

            if(dani[i].day > targetDay) {

                calculate(keksCount,daniJedenja,targetDay - currentDay + 1);

                currentDay = targetDay;
                break;
            }
            else {

                calculate(keksCount,daniJedenja,dani[i].day - currentDay);

                keksCount += dani[i].keks;
                currentDay = dani[i].day;
            }
        }

        if(targetDay > dani[n-1].day) {

            calculate(keksCount,daniJedenja,targetDay - currentDay + 1);
            currentDay = targetDay;
        }
        std::cout << daniJedenja << std::endl;
    }

    return 0;
}