#include <iostream>
#include <vector>
using namespace std;

int najblizi_manji_broj_index(const vector<unsigned long long>& d, int N, unsigned long long k) {
    int levi_kraj = 0;
    int desni_kraj = N - 1;
    int trazeni_index = -1;

    while (levi_kraj <= desni_kraj) {
        int srediste = levi_kraj + (desni_kraj - levi_kraj) / 2;

        if (d[srediste] < k) {
            trazeni_index = srediste;
            levi_kraj = srediste + 1;
        } else {
            desni_kraj = srediste - 1;
        }
    }

    return trazeni_index;
}

int main() {
    ios_base::sync_with_stdio(false);
    unsigned int N,Q;
    cin >> N >> Q; //broj ocevih kupovina - broj pitanja

    vector<unsigned long long> d(N), k(Q);
    vector<unsigned int> p(N), pojedenih(N), ostalo(N);

    for(int i = 0; i<N; i++){
        cin >> d[i] >> p[i]; //dan oceve kupovine - broj pakovanja kupljenih tog dana
    }
    for(int j = 0; j<Q; j++){
        cin >> k[j]; //koliko je pojela pakovanja do tog dana
    }

    pojedenih[0] = 1;
    ostalo[0] = p[0] - 1;

    for(int i = 1; i<N; i++){
        pojedenih[i] = pojedenih[i-1];
        if(ostalo[i-1] < d[i] - d[i-1]){
            pojedenih[i] += ostalo[i-1] + 1;
            ostalo[i] = p[i] - 1;
        }
        else{
            pojedenih[i] += d[i] - d[i-1];
            ostalo[i] = ostalo[i-1] - d[i] + d[i-1] + p[i];
        }
    }

    unsigned long long resenje;
    for(int j = 0; j<Q; j++){
        if(k[j] < d[0]){
            cout << "0" << '\n';
        }
        else if(k[j] == d[0]){
            cout << "1" << '\n';
        }
        else{
            unsigned long long index = najblizi_manji_broj_index(d, N, k[j]);
            if(k[j]-d[index] > ostalo[index]){
                resenje = pojedenih[index] + ostalo[index];
            }
            else{
                resenje = pojedenih[index] + k[j] - d[index];
            }
            cout << resenje << '\n';
        }
    }
    
    return 0;
}