#include <iostream>
#include <queue>
#include <vector>
using namespace std;

bool slobodno_polje(int x, int y, int N, int M, const vector<string>& lavirint){
    return x >= 0 and x < N and y >= 0 and y < M and lavirint[x][y] == '.';
}

int bfs(unsigned int N, unsigned int M,int steva_x, int steva_y, vector<string>& lavirint, vector<vector<int>>& vreme_vatra, vector<vector<int>>& vreme_steva){

    queue<pair<int, int>> vatra_queue;
    queue<pair<int, int>> steva_queue;

    //BFS za Stevu inicijalizacija
    steva_queue.push({steva_x, steva_y});
    vreme_steva[steva_x][steva_y] = 0;

    //BFS za vatru inicijalizacija
    for(int i = 0; i < N; i++){
        for(int j = 0; j < M; j++){
            if(lavirint[i][j] == 'X'){
                vatra_queue.push({i, j});
                vreme_vatra[i][j] = 0;
            }
        }
    }

    const int dx[] = {-1, 1, 0, 0};
    const int dy[] = {0, 0, -1, 1};

    //BFS za vatru
    while(!vatra_queue.empty()){
        auto [x, y] = vatra_queue.front();
        vatra_queue.pop();

        for(int i = 0; i < 4; i++){
            int nx = x + dx[i];
            int ny = y + dy[i];

            if(slobodno_polje(nx, ny, N, M, lavirint) and vreme_vatra[nx][ny] == -1){
                vreme_vatra[nx][ny] = vreme_vatra[x][y] + 1;
                vatra_queue.push({nx, ny});
            }
        }
    }

    int broj_polja = 1; //Startna poizicija

    //BFS za stevu
    while(!steva_queue.empty()){
        auto[x, y] = steva_queue.front();
        steva_queue.pop();

        for(int i = 0; i < 4; ++i){
            int nx = x + dx[i];
            int ny = y + dy[i];

            if(slobodno_polje(nx, ny, N, M, lavirint) and vreme_steva[nx][ny] == -1){
                int vreme_do_polja = vreme_steva[x][y] + 1;

                if(vreme_vatra[nx][ny] == -1 or vreme_do_polja < vreme_vatra[nx][ny]){
                    vreme_steva[nx][ny] = vreme_do_polja;
                    steva_queue.push({nx, ny});
                    broj_polja++;
                }
            }
        }
    }
    return broj_polja;
}

int main(){
    unsigned int N, M;
    cin >> N >> M; //dimenzije lavirinta

    vector<string> lavirint(N);
    int steva_x, steva_y;

    for(int i = 0; i < N; i++){
        cin >> lavirint[i]; //unos lavirinta
        for(int j = 0; j < M; j++){
            if(lavirint[i][j] == 'S'){
                steva_x = i; //koordinata x Steve
                steva_y = j; //koordinata y Steve
            }
        }
    }

    vector<vector<int>> vreme_vatra(N, vector<int>(M,-1));
    vector<vector<int>> vreme_steva(N, vector<int>(M,-1));

    int resenje = bfs(N, M, steva_x, steva_y, lavirint, vreme_vatra, vreme_steva);

    cout << resenje << endl;
    return 0;
}