#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

struct Event {
    long long day;
    long long packages;
    int queryIndex;
};

bool compareEvents(const Event& a, const Event& b) {
    return a.day < b.day;
}

int main() {
    int N, Q;
    cin >> N >> Q;

    vector<Event> events;
    for (int i = 0; i < N; i++) {
        long long day, packages;
        cin >> day >> packages;
        events.push_back({day, packages, -1});
    }

    vector<long long> queries(Q);
    for (int i = 0; i < Q; i++) {
        cin >> queries[i];
        events.push_back({queries[i], 0, i});
    }

    sort(events.begin(), events.end(), compareEvents);

    long long totalEaten = 0;
    long long lastDay = 0;
    long long availablePackages = 0;
    vector<long long> results(Q);

    for (const auto& event : events) {
        long long currentDay = event.day;
        if (event.packages > 0) {
            availablePackages += event.packages;
        } else {
            long long remainingDays = currentDay - lastDay;
            totalEaten += min(remainingDays, availablePackages);
            results[event.queryIndex] = totalEaten;
        }
        lastDay = currentDay;
    }

    for (int i = 0; i < Q; i++) {
        cout << results[i] << endl;
    }

    return 0;
}