#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
using namespace std;

const int INF = 1e9;

struct Point {
    int x, y;
};

vector<Point> directions = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};

bool isValid(int x, int y, int N, int M, const vector<string>& grid) {
    return x >= 0 && x < N && y >= 0 && y < M && grid[x][y] != '*';
}

vector<vector<int>> bfs(const vector<Point>& starts, int N, int M, const vector<string>& grid) {
    vector<vector<int>> time(N, vector<int>(M, INF));
    queue<Point> q;

    for (const auto& start : starts) {
        q.push(start);
        time[start.x][start.y] = 0;
    }

    while (!q.empty()) {
        Point cur = q.front();
        q.pop();

        for (const auto& dir : directions) {
            int nx = cur.x + dir.x, ny = cur.y + dir.y;
            if (isValid(nx, ny, N, M, grid) && time[nx][ny] == INF) {
                time[nx][ny] = time[cur.x][cur.y] + 1;
                q.push({nx, ny});
            }
        }
    }
    return time;
}

int main()
{
    int N, M;
    cin >> N >> M;

    vector<string> grid(N);
    Point steva;
    vector<Point> fires;

    for (int i = 0; i < N; ++i) {
        cin >> grid[i];
        for (int j = 0; j < M; ++j) {
            if (grid[i][j] == 'S') steva = {i, j};
            else if (grid[i][j] == 'X') fires.push_back({i, j});
        }
    }

    vector<vector<int>> fireTime = bfs(fires, N, M, grid);

    vector<vector<int>> stevaTime = bfs({steva}, N, M, grid);

    int count = 0;
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            if (grid[i][j] == '.' || grid[i][j] == 'S') {
                if (stevaTime[i][j] < fireTime[i][j]) {
                    ++count;
                }
            }
        }
    }

    cout << count << endl;
    return 0;
}