#include <iostream>
#include <queue>
#include <vector>
#include <cstring>
#define MAXN 1005
using namespace std;


int N, M;
char grid[MAXN][MAXN];
int VremeVatre[MAXN][MAXN], VremSteve[MAXN][MAXN];

int dx[] = {-1, 1, 0, 0};
int dy[] = {0, 0, -1, 1};


void BFSVatra(queue<pair<int, int>>& VatreniRed) {
   
    memset(VremeVatre, -1, sizeof(VremeVatre));

    while (VatreniRed.empty()==false) {
        pair<int, int> current = VatreniRed.front();
        VatreniRed.pop();

        int x = current.first, y = current.second;

      
        if (VremeVatre[x][y] == -1) {
            VremeVatre[x][y] = 0;
        }

     
        for (int i = 0; i < 4; ++i) {
            int nx = x + dx[i], ny = y + dy[i];
            if (nx >= 0 && ny >= 0 && nx < N && ny < M && grid[nx][ny] == '.' && VremeVatre[nx][ny] == -1) {
                VremeVatre[nx][ny] = VremeVatre[x][y] + 1;
                VatreniRed.push(make_pair(nx, ny));
            }
        }
    }
}


void BFSSteva(pair<int, int> steva_start) {

    memset(VremSteve, -1, sizeof(VremSteve));

    queue<pair<int, int>> stevaRed;
    stevaRed.push(steva_start);
    VremSteve[steva_start.first][steva_start.second] = 0;

    while (stevaRed.empty()==false) {
        pair<int, int> current = stevaRed.front();
        stevaRed.pop();

        int x = current.first, y = current.second;

      
        for (int i = 0; i < 4; ++i) {
            int nx = x + dx[i], ny = y + dy[i];
            if (nx >= 0 && ny >= 0 && nx < N && ny < M && grid[nx][ny] == '.' && VremSteve[nx][ny] == -1) {
                VremSteve[nx][ny] = VremSteve[x][y] + 1;
                stevaRed.push(make_pair(nx, ny));
            }
        }
    }
}

int main() {

    cin >> N >> M;
    pair<int, int> steva_start;
    queue<pair<int, int>> VatreniRed;

    
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            cin >> grid[i][j];
            if (grid[i][j] == 'S')
                
                steva_start = make_pair(i, j);

            if (grid[i][j] == 'X')
               
                VatreniRed.push(make_pair(i, j));

        }
    }


    BFSVatra(VatreniRed);


    BFSSteva(steva_start);

   
    int count = 1;

   
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {

            if (grid[i][j] == '.' && VremSteve[i][j] != -1 &&
                (VremeVatre[i][j] == -1 || VremSteve[i][j] < VremeVatre[i][j])) {
                count++;
            }
        }
    }

    std::cout << count << endl;
    return 0;
}