using System;
namespace C_pozar
{
    internal class Program
    {
        static void Main(string[] args)
        {
            string[] linija = Console.ReadLine().Split(' ');
            int n = int.Parse(linija[0]);
            int m = int.Parse(linija[1]);

            char[,] lavirint = new char[n, m];

            int pocetakX = 0;
            int pocetakY = 0;

            for (int red = 0; red < n; red++)
            {
                string red_ulaza = Console.ReadLine();
                for (int kolona = 0; kolona < m; kolona++)
                {
                    lavirint[red, kolona] = red_ulaza[kolona];

                    if (red_ulaza[kolona] == 'S')
                    {
                        pocetakX = kolona;
                        pocetakY = red;
                    }
                }
            }

            int[,] potezi = { { 0, 1 },    //desno
                              { 1, 0 },    //dole
                              { 0, -1 },   //levo 
                              { -1, 0 } }; //gore

            int[,] vatra_potezi = PoteziVatre(lavirint, potezi);
            int[,] steva_potezi = PoteziSteve(lavirint, potezi);

            Console.WriteLine(IzbrojMogucaPolja(vatra_potezi, steva_potezi));
        }

        private static int IzbrojMogucaPolja(int[,] vatra_potezi, int[,] steva_potezi)
        {
            int brojac = 0;
            for (int red = 0; red < vatra_potezi.GetLength(0); red++)
            {
                for (int kolona = 0; kolona < vatra_potezi.GetLength(1); kolona++)
                {
                    if ((vatra_potezi[red, kolona] >= 0 && steva_potezi[red, kolona] >= 0 && vatra_potezi[red, kolona] > steva_potezi[red, kolona]) ||
                        (vatra_potezi[red, kolona] == -3 && steva_potezi[red, kolona] >= 0))
                    {
                        brojac++;
                    }
                }
            }
            return brojac;
        }

        private static int[,] PoteziSteve(char[,] lavirint, int[,] potezi)
        {
            int brojac = 0;
            int[,] steva_potezi = new int[lavirint.GetLength(0), lavirint.GetLength(1)];
            for (int red = 0; red < lavirint.GetLength(0); red++)
            {
                for (int kolona = 0; kolona < lavirint.GetLength(1); kolona++)
                {
                    if (lavirint[red, kolona] == '.' || lavirint[red, kolona] == 'X')
                    {
                        steva_potezi[red, kolona] = -1;
                    }
                    else if (lavirint[red, kolona] == '*')
                    {
                        steva_potezi[red, kolona] = -2;
                    }
                }
            }

            while (true)
            {
                bool a = true;
                for (int red = 0; red < lavirint.GetLength(0); red++)
                {
                    for (int kolona = 0; kolona < lavirint.GetLength(1); kolona++)
                    {
                        if (steva_potezi[red, kolona] >= 0)
                        {
                            for (int i = 0; i < potezi.GetLength(0); i++)
                            {
                                int novoX = kolona + potezi[i, 1];
                                int novoY = red + potezi[i, 0];

                                if (novoX >= 0 && novoX < lavirint.GetLength(1) &&
                                    novoY >= 0 && novoY < lavirint.GetLength(0) &&
                                    steva_potezi[novoY, novoX] == -1)
                                {
                                    a = false;
                                    steva_potezi[novoY, novoX] = -3;
                                }

                            }
                        }
                    }
                }

                if (a) break;

                brojac++;
                for (int red = 0; red < lavirint.GetLength(0); red++)
                {
                    for (int kolona = 0; kolona < lavirint.GetLength(1); kolona++)
                    {
                        if (steva_potezi[red, kolona] == -3)
                        {
                            steva_potezi[red, kolona] = brojac;
                        }
                    }
                }
            }

            for (int red = 0; red < lavirint.GetLength(0); red++)
            {
                for (int kolona = 0; kolona < lavirint.GetLength(1); kolona++)
                {
                    if (steva_potezi[red, kolona] == -1)
                    {
                        steva_potezi[red, kolona] = -3;
                    }
                }
            }

            return steva_potezi;
        }

        private static int[,] PoteziVatre(char[,] lavirint, int[,] potezi)
        {
            int brojac = 0;
            int[,] vatra_potezi = new int[lavirint.GetLength(0), lavirint.GetLength(1)];
            for (int red = 0; red < lavirint.GetLength(0); red++)
            {
                for (int kolona = 0; kolona < lavirint.GetLength(1); kolona++)
                {
                    if (lavirint[red, kolona] == '.' || lavirint[red, kolona] == 'S')
                    {
                        vatra_potezi[red, kolona] = -1;
                    }
                    else if (lavirint[red, kolona] == '*')
                    {
                        vatra_potezi[red, kolona] = -2;
                    }
                }
            }

            
            while (true)
            {
                bool a = true;
                for (int red = 0; red < lavirint.GetLength(0); red++)
                {
                    for (int kolona = 0; kolona < lavirint.GetLength(1); kolona++)
                    {
                        if (vatra_potezi[red, kolona] >= 0)
                        {
                            for (int i = 0; i < potezi.GetLength(0); i++)
                            {
                                int novoX = kolona + potezi[i, 1];
                                int novoY = red + potezi[i, 0];

                                if (novoX >= 0 && novoX < lavirint.GetLength(1) &&
                                    novoY >= 0 && novoY < lavirint.GetLength(0) &&
                                    vatra_potezi[novoY, novoX] == -1)
                                {
                                    a = false;
                                    vatra_potezi[novoY, novoX] = -3;
                                }

                            }
                        }
                    }
                }

                if (a) break;

                brojac++;
                for (int red = 0; red < lavirint.GetLength(0); red++)
                {
                    for (int kolona = 0; kolona < lavirint.GetLength(1); kolona++)
                    {
                        if (vatra_potezi[red, kolona] == -3)
                        {
                            vatra_potezi[red, kolona] = brojac;
                        }
                    }
                }
            }

            for (int red = 0; red < lavirint.GetLength(0); red++)
            {
                for (int kolona = 0; kolona < lavirint.GetLength(1); kolona++)
                {
                    if (vatra_potezi[red, kolona] == -1)
                    {
                        vatra_potezi[red, kolona] = -3;
                    }
                }
            }

            return vatra_potezi;
        }
    }
}