#include <iostream>
#include <queue>
#include <vector>
using namespace std;

const int dx[] = {-1, 0, 1, 0};
const int dy[] = {0, 1, 0, -1};

int n, m;
vector<string> lavirint;
vector<vector<int>> vreme_vatre;
vector<vector<int>> vreme_steve;

bool proveri(int x, int y) {
  return x >= 0 && x < n && y >= 0 && y < m && lavirint[x][y] != '*';
}

void sirenje_vatre() {
  queue<pair<int, int>> red;
  vreme_vatre = vector<vector<int>>(n, vector<int>(m, 1e9));

  for (int i = 0; i < n; i++) {
    for (int j = 0; j < m; j++) {
      if (lavirint[i][j] == 'X') {
        red.push({i, j});
        vreme_vatre[i][j] = 0;
      }
    }
  }

  while (!red.empty()) {
    int x = red.front().first;
    int y = red.front().second;
    red.pop();

    for (int d = 0; d < 4; d++) {
      int nx = x + dx[d];
      int ny = y + dy[d];
      if (proveri(nx, ny) && vreme_vatre[nx][ny] > vreme_vatre[x][y] + 1) {
        vreme_vatre[nx][ny] = vreme_vatre[x][y] + 1;
        red.push({nx, ny});
      }
    }
  }
}

void kretanje_steve(int pocetno_x, int pocetno_y) {
  queue<pair<int, int>> red;
  vreme_steve = vector<vector<int>>(n, vector<int>(m, 1e9));

  red.push({pocetno_x, pocetno_y});
  vreme_steve[pocetno_x][pocetno_y] = 0;

  while (!red.empty()) {
    int x = red.front().first;
    int y = red.front().second;
    red.pop();

    for (int d = 0; d < 4; d++) {
      int nx = x + dx[d];
      int ny = y + dy[d];
      if (proveri(nx, ny) && vreme_steve[nx][ny] > vreme_steve[x][y] + 1) {
        vreme_steve[nx][ny] = vreme_steve[x][y] + 1;
        red.push({nx, ny});
      }
    }
  }
}

int main() {
  cin >> n >> m;
  lavirint.resize(n);
  int steva_x, steva_y;

  for (int i = 0; i < n; i++) {
    cin >> lavirint[i];
    for (int j = 0; j < m; j++) {
      if (lavirint[i][j] == 'S') {
        steva_x = i;
        steva_y = j;
      }
    }
  }

  sirenje_vatre();
  kretanje_steve(steva_x, steva_y);

  int bezbedna_polja = 0;
  for (int i = 0; i < n; i++) {
    for (int j = 0; j < m; j++) {
      if (proveri(i, j) && vreme_steve[i][j] < vreme_vatre[i][j]) {
        bezbedna_polja++;
      }
    }
  }

  cout << bezbedna_polja << endl;
  return 0;
}