from collections import deque

def resenje(matrica, n, m):
    vreme_vatre = [[float('inf')] * m for _ in range(n)]
    vreme_osobe = [[float('inf')] * m for _ in range(n)]
    
    red = deque()
    
    for i in range(n):
        for j in range(m):
            if matrica[i][j] == 'X':
                red.append((i, j, 'V'))
                vreme_vatre[i][j] = 0
            elif matrica[i][j] == 'S':
                red.append((i, j, 'O'))
                vreme_osobe[i][j] = 0
    
    pravci = [(-1, 0), (1, 0), (0, -1), (0, 1)]
    
    while red:
        x, y, entitet = red.popleft()
        
        if entitet == 'V':
            trenut = vreme_vatre[x][y]
        elif entitet == 'O':
            trenut = vreme_osobe[x][y]
        
        for dx, dy in pravci:
            nx, ny = x + dx, y + dy
            if 0 <= nx < n and 0 <= ny < m:
                if entitet == 'V' and matrica[nx][ny] == '.' and vreme_vatre[nx][ny] == float('inf'):
                    vreme_vatre[nx][ny] = trenut + 1
                    red.append((nx, ny, 'V'))
                if entitet == 'O' and matrica[nx][ny] == '.' and vreme_osobe[nx][ny] == float('inf'):
                    vreme_osobe[nx][ny] = trenut + 1
                    red.append((nx, ny, 'O'))
    
    brojac = 0
    for i in range(n):
        for j in range(m):
            if matrica[i][j] == '.' and vreme_osobe[i][j] < vreme_vatre[i][j]:
                brojac += 1
    
    return brojac + 1

def main():
    n, m = map(int, input().split())
    matrica = []
    for _ in range(n):
        matrica.append(list(input().strip()))
    
    rezultat = resenje(matrica, n, m)
    print(rezultat)

if __name__ == "__main__":
    main()