#include <iostream>
#include <algorithm>

#define ull unsigned long long

using namespace std;

int N, Q;
ull d[300000], a[300000], e[300000];

int findDay(ull value) {
    int left = 0;
    int right = N - 1;
    int index = -1;

    while (left <= right) {
        int mid = left + (right - left) / 2;

        if (d[mid] == value) {
            return mid;
        } else if (d[mid] < value) {
            index = mid;
            left = mid + 1;
        } else {
            right = mid - 1;
        }
    }

    return index;
}

int main() {
    cin >> N >> Q;
    {
        ull available = 0;
        ull previousDay = 0;
        ull totalEaten = 0;
        for (ull i = 0; i < N; i += 1) {
            ull day, p;
            cin >> day >> p;
            d[i] = day;

            ull dayDelta = day - previousDay;
            previousDay = day;

            ull eaten = min(available, dayDelta);
            totalEaten += eaten;
            e[i] = totalEaten;

            available = available + p - eaten;
            a[i] = available;
//        printf("Day %llu: plasma %llu, available %llu, eaten %llu, a[i] %llu, e[i] %llu \n", day, p,
//               available, eaten, a[i], e[i]);
        }
    }
    for (ull i = 0; i < Q; i += 1) {
        ull day;
        cin >> day;

        int index = findDay(day);
        if (index == -1) {
            cout << 0 << endl;
            continue;
        }

        ull dayFound = d[index];
        ull eaten = e[index];
        ull av = a[index];
        ull dayDelta = day - dayFound + 1;
        ull eat = min(av, dayDelta);
        ull total = eaten + eat;
        cout << total << endl;
//        printf("dayFound %llu, eaten %llu, av %llu, dayDelta %llu\n", dayFound, eaten, av, dayDelta);
    }
    return 0;
}