def input_grid():

    rows, cols = map(int, input().split())

    nivo = {}

    for y in range(rows):
        row = input().strip()
        if len(row) != cols:
            exit()
        for x, char in enumerate(row):
            nivo[(x, y)] = char
    return nivo, rows, cols
    
    
def simuliraj(nivo, rows, cols):

    simulacija_u_toku = True
    potezi = 0

    while simulacija_u_toku:
        
        nivo_kopija = nivo.copy()
        
        for (x, y), value in nivo_kopija.items():
            if value == 'X':  
                sledece_tacke = [(x + 1, y), (x - 1, y), (x, y + 1), (x, y - 1)]
                for nx, ny in sledece_tacke:
                    if (nx, ny) in nivo_kopija and nivo_kopija[(nx, ny)] == '.':
                        nivo[(nx, ny)] = 'X'  
                        
        for (x, y), value in nivo_kopija.items():
            if value == 'S':  
                sledece_tacke = [(x + 1, y), (x - 1, y), (x, y + 1), (x, y - 1)]
                for nx, ny in sledece_tacke:
                    if (nx, ny) in nivo_kopija and nivo_kopija[(nx, ny)] == '.':
                        nivo[(nx, ny)] = 'S'  
                        
        potezi += 1
      
        for y in range(rows):
            line = ''.join(nivo.get((x, y), ' ') for x in range(cols))
            
        if all(value != '.' for value in nivo.values()):
            simulacija_u_toku = False
            
    return sum(1 for value in nivo.values() if value == 'S')

if __name__ == "__main__":
    nivo, rows, cols = input_grid()
    if nivo is not None:
        result = simuliraj(nivo, rows, cols)
        print(result)