using System;
using System.Collections.Generic;

class Program
{
    static int[] pomerajX = { -1, 1, 0, 0 };
    static int[] pomerajY = { 0, 0, -1, 1 };
    static void siriv(int n, int m, Queue<(int, int)> redVatre, int[,] vremeVatre, char[,] lavirint)
    {
        while (redVatre.Count > 0)
        {
            var (x, y) = redVatre.Dequeue();
            for (int i = 0; i < 4; i++)
            {
                int nx = x + pomerajX[i], ny = y + pomerajY[i];
                if (nx >= 0 && ny >= 0 && nx < n && ny < m && vremeVatre[nx, ny] == -1 && lavirint[nx, ny] != '*')
                {
                    vremeVatre[nx, ny] = vremeVatre[x, y] + 1;
                    redVatre.Enqueue((nx, ny));
                }
            }
        }
    }

    static void siris(int n, int m, Queue<(int, int)> redSteve, int[,] vremeSteve, int[,] vremeVatre, char[,] lavirint)
    {
        while (redSteve.Count > 0)
        {
            var (x, y) = redSteve.Dequeue();
            for (int i = 0; i < 4; i++)
            {
                int nx = x + pomerajX[i], ny = y + pomerajY[i];
                if (nx >= 0 && ny >= 0 && nx < n && ny < m && vremeSteve[nx, ny] == -1 && lavirint[nx, ny] != '*')
                {
                    if (vremeVatre[nx, ny] == -1 || vremeSteve[x, y] + 1 < vremeVatre[nx, ny])
                    {
                        vremeSteve[nx, ny] = vremeSteve[x, y] + 1;
                        redSteve.Enqueue((nx, ny));
                    }
                }
            }
        }
    }
    static void Main()
    {
        var s1 = Console.ReadLine().Split();
        int n = int.Parse(s1[0]);
        int m = int.Parse(s1[1]);
        char[,] lavirint = new char[n, m];
        Queue<(int, int)> redVatre = new Queue<(int, int)>();
        Queue<(int, int)> redSteve = new Queue<(int, int)>();
        int pocetniX = -1, pocetniY = -1;

        for (int i = 0; i < n; i++)
        {
            var linija = Console.ReadLine();
            for (int j = 0; j < m; j++)
            {
                lavirint[i, j] = linija[j];
                if (lavirint[i, j] == 'X')
                {
                    redVatre.Enqueue((i, j));
                }
                if (lavirint[i, j] == 'S')
                {
                    pocetniX = i;
                    pocetniY = j;
                    lavirint[i, j] = '.';
                }
            }
        }

        int[,] vremeVatre = new int[n, m];
        int[,] vremeSteve = new int[n, m];
        for (int i = 0; i < n; i++)
            for (int j = 0; j < m; j++)
            {
                vremeVatre[i, j] = -1;
                vremeSteve[i, j] = -1;
            }

        siriv(n, m, redVatre, vremeVatre, lavirint);

        redSteve.Enqueue((pocetniX, pocetniY));
        vremeSteve[pocetniX, pocetniY] = 0;

        siris(n, m, redSteve, vremeSteve, vremeVatre, lavirint);

        int brojDostupnihPolja = 0;
        for (int i = 0; i < n; i++)
        {
            for (int j = 0; j < m; j++)
            {
                if (vremeSteve[i, j] != -1 && (vremeVatre[i, j] == -1 || vremeSteve[i, j] < vremeVatre[i, j]))
                {
                    brojDostupnihPolja++;
                }
            }
        }

        Console.WriteLine(brojDostupnihPolja);
    }
}