import java.util.*;

public class LavaMaze {
    static int N, M;
    static char[][] maze;
    static int[][] fireTime; // Koliko vremena je potrebno vatri da stigne do svakog polja
    static int[][] steveTime; // Koliko vremena Stevi treba da stigne do svakog polja

    // Koordinate za kretanje u 4 pravca (gore, dole, levo, desno)
    static int[] dx = {-1, 1, 0, 0};
    static int[] dy = {0, 0, -1, 1};
    
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        
        // Unos dimenzija lavirinta
        N = sc.nextInt();
        M = sc.nextInt();
        sc.nextLine(); // Citanje novog reda nakon unosa dimenzija
        
        maze = new char[N][M];
        fireTime = new int[N][M];
        steveTime = new int[N][M];
        
        // Inicijalizacija lavirinta, vatrenih vremena i Stevinog vremena
        for (int i = 0; i < N; i++) {
            String line = sc.nextLine();
            for (int j = 0; j < M; j++) {
                maze[i][j] = line.charAt(j);
                fireTime[i][j] = Integer.MAX_VALUE; // Pocetna vrednost za vatru
                steveTime[i][j] = Integer.MAX_VALUE; // Pocetna vrednost za Stevu
            }
        }
        
        // Pronaci pozicije vatre i Stevin pocetak
        Queue<int[]> fireQueue = new LinkedList<>();
        Queue<int[]> steveQueue = new LinkedList<>();
        
        // Unos pocetnih pozicija vatre i Steve
        int steveStartX = -1, steveStartY = -1;
        
        // Citanje lavirinta i inicijalizacija pocetnih tacaka
        for (int i = 0; i < N; i++) {
            for (int j = 0; j < M; j++) {
                if (maze[i][j] == 'F') {
                    fireQueue.offer(new int[]{i, j});
                    fireTime[i][j] = 0; // Pocetno vreme za vatru je 0
                }
                if (maze[i][j] == 'S') {
                    steveStartX = i;
                    steveStartY = j;
                    steveQueue.offer(new int[]{i, j});
                    steveTime[i][j] = 0; // Pocetno vreme za Stevu je 0
                }
            }
        }
        
        // BFS za širenje vatre
        bfsFire(fireQueue);
        
        // BFS za Stevu
        bfsSteve(steveQueue);
        
        // Brojanje bezbednih polja
        int safeFields = 0;
        for (int i = 0; i < N; i++) {
            for (int j = 0; j < M; j++) {
                if (maze[i][j] == '.' && steveTime[i][j] < fireTime[i][j]) {
                    safeFields++;
                }
            }
        }
        
        // Ispis rezultata
        System.out.println(safeFields);
    }

    // BFS za širenje vatre
    public static void bfsFire(Queue<int[]> queue) {
        while (!queue.isEmpty()) {
            int[] cell = queue.poll();
            int x = cell[0], y = cell[1];
            
            // Istražujemo susedna polja
            for (int i = 0; i < 4; i++) {
                int nx = x + dx[i], ny = y + dy[i];
                
                // Provera da li je novo polje unutar lavirinta i slobodno
                if (nx >= 0 && ny >= 0 && nx < N && ny < M && maze[nx][ny] == '.') {
                    if (fireTime[nx][ny] > fireTime[x][y] + 1) {
                        fireTime[nx][ny] = fireTime[x][y] + 1;
                        queue.offer(new int[]{nx, ny});
                    }
                }
            }
        }
    }

    // BFS za Stevu
    public static void bfsSteve(Queue<int[]> queue) {
        while (!queue.isEmpty()) {
            int[] cell = queue.poll();
            int x = cell[0], y = cell[1];
            
            // Istražujemo susedna polja
            for (int i = 0; i < 4; i++) {
                int nx = x + dx[i], ny = y + dy[i];
                
                // Provera da li je novo polje unutar lavirinta i slobodno
                if (nx >= 0 && ny >= 0 && nx < N && ny < M && maze[nx][ny] == '.') {
                    if (steveTime[nx][ny] > steveTime[x][y] + 1) {
                        steveTime[nx][ny] = steveTime[x][y] + 1;
                        queue.offer(new int[]{nx, ny});
                    }
                }
            }
        }
    }
}